/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.utils.sse;

import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class SSEEventsAggregator implements SseListener {

  private final List<ServerSentEvent> receivedEvents = new ArrayList<>();
  private final CompletableFuture<List<ServerSentEvent>> resultFuture = new CompletableFuture<>();

  @Override
  public void onEvent(ServerSentEvent event) {
    receivedEvents.add(event);
  }

  @Override
  public void onClose() {
    resultFuture.complete(receivedEvents);
  }

  public List<ServerSentEvent> getList() throws ExecutionException, InterruptedException {
    return resultFuture.get();
  }
}
