/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.mule.service.http.netty.impl.message.HttpResponseCreator;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1)
public class HttpResponseCreatorBenchmark {
    @Benchmark
    @Threads(value=1)
    @Warmup(iterations=3, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=10, time=5, timeUnit=TimeUnit.SECONDS)
    public void adaptReactorNettyResponseToMule(ExecPlan state) {
        state.httpResponseCreator.create(state.reactorNettyResponse, state.body);
    }

    @State(value=Scope.Benchmark)
    public static class ExecPlan {
        public HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
        public HttpClientResponse reactorNettyResponse;
        public InputStream body = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };

        @Setup
        public void setUp() {
            Integer port = Integer.getInteger("mock.server.port");
            WireMockServer mockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(port.intValue()));
            mockServer.start();
            mockServer.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Length", new String[]{"0"}).withHeader("X-Header1", new String[]{"value"}).withHeader("X-Header2", new String[]{"value"}).withHeader("X-Header3", new String[]{"value"}).withHeader("X-Header4", new String[]{"value"}).withHeader("X-Header5", new String[]{"value"})));
            HttpClient reactorNettyClient = HttpClient.create();
            this.reactorNettyResponse = (HttpClientResponse)((HttpClient.ResponseReceiver)reactorNettyClient.get().uri("http://localhost:" + port + "/")).response().block();
            this.httpResponseCreator = new HttpResponseCreator();
            mockServer.stop();
        }
    }
}

