/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.service.http.test.common.server.HttpServerTransferTestCase;

public class HttpServerTransfer10TestCase
extends HttpServerTransferTestCase {
    public static final String CRLF = "\r\n";

    public HttpServerTransfer10TestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public HttpVersion getVersion() {
        return HttpVersion.HTTP_1_0;
    }

    @Test
    void defaultsStreamingWhenEmpty() throws Exception {
        this.verify10Headers("", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "");
    }

    @Test
    void defaultsStreamingWhenBytes() throws Exception {
        this.verify10Headers("/bytes", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    @Test
    void defaultsStreamingWhenMultipart() throws Exception {
        this.verify10Headers("/multipart", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nMy awesome data\r\n--bounds--\r\n");
    }

    @Test
    void defaultsStreamingWhenStream() throws Exception {
        this.verify10Headers("/stream", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    private void verify10Headers(String path, String expectedConnection, Matcher<Object> contentLengthMatcher, String expectedBody) throws IOException {
        try (Socket socket = new Socket("localhost", (int)this.port);
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
             BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            String headerLine;
            String requestPath = path.isEmpty() ? "/" : path;
            out.println("GET " + requestPath + " HTTP/1.0");
            out.println("Host: localhost:" + this.port);
            out.println("Connection: close");
            out.println();
            String statusLine = in.readLine();
            MatcherAssert.assertThat((String)"Status line should indicate HTTP/1.0 and 200", (Object)statusLine.startsWith("HTTP/1.0 200"), (Matcher)Matchers.is((Object)true));
            String contentLengthValue = null;
            String connectionValue = null;
            while ((headerLine = in.readLine()) != null && !headerLine.isEmpty()) {
                String[] parts = headerLine.split(":", 2);
                if (parts.length != 2) continue;
                String headerName = parts[0].trim().toLowerCase();
                if (headerName.equals("content-length")) {
                    contentLengthValue = parts[1].trim();
                }
                if (!headerName.equals("connection")) continue;
                connectionValue = parts[1].trim();
            }
            StringBuilder body = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (body.length() != 0) {
                    body.append(CRLF);
                }
                body.append(line);
            }
            MatcherAssert.assertThat(connectionValue, (Matcher)Matchers.is((Object)expectedConnection));
            MatcherAssert.assertThat(contentLengthValue, contentLengthMatcher);
            MatcherAssert.assertThat((Object)body.toString(), (Matcher)Matchers.equalToCompressingWhiteSpace((String)expectedBody));
        }
    }
}

