/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tls.TlsContextFactory;

public final class SslContextHelper {
    private SslContextHelper() {
    }

    public static SslContext sslContextForServer(TlsContextFactory tlsContextFactory, boolean allowHttp1, boolean allowHttp2) throws NoSuchAlgorithmException, KeyManagementException {
        if (tlsContextFactory == null) {
            return null;
        }
        ClientAuth clientAuth = tlsContextFactory.isTrustStoreConfigured() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, SslContextHelper.getCiphers(tlsContextFactory), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, SslContextHelper.getProtocols(allowHttp1, allowHttp2)), clientAuth, tlsContextFactory.getEnabledProtocols(), false);
    }

    private static List<String> getProtocols(boolean allowHttp1, boolean allowHttp2) {
        if (allowHttp1 && allowHttp2) {
            return List.of("h2", "http/1.1");
        }
        if (allowHttp1) {
            return List.of("http/1.1");
        }
        if (allowHttp2) {
            return List.of("h2");
        }
        return List.of();
    }

    public static SslContext sslContextForClient(TlsContextFactory tlsContextFactory, boolean allowHttp1, boolean allowHttp2) {
        if (tlsContextFactory == null) {
            return null;
        }
        try {
            return new JdkSslContext(tlsContextFactory.createSslContext(), true, SslContextHelper.getCiphers(tlsContextFactory), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, SslContextHelper.getProtocols(allowHttp1, allowHttp2)), ClientAuth.NONE, tlsContextFactory.getEnabledProtocols(), false);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static Iterable<String> getCiphers(TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory == null) {
            return null;
        }
        String[] enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites();
        if (enabledCipherSuites == null) {
            return null;
        }
        return Arrays.asList(enabledCipherSuites);
    }
}

