/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.sse;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;

public class ResponseBodyWriter
extends Writer {
    private final ChannelHandlerContext ctx;
    private final Charset encoding;
    private final ResponseStatusCallback callback;
    private final StringBuilder stringBuilder;

    public ResponseBodyWriter(ChannelHandlerContext ctx, Charset encoding, ResponseStatusCallback callback) {
        this.ctx = ctx;
        this.encoding = encoding;
        this.callback = callback;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void write(char[] charBuffer, int off, int len) throws IOException {
        this.stringBuilder.append(charBuffer, off, len);
    }

    @Override
    public void flush() {
        byte[] bytes = this.stringBuilder.toString().getBytes(this.encoding);
        ByteBuf byteBuf = this.ctx.alloc().buffer(bytes.length);
        byteBuf.writeBytes(bytes);
        this.stringBuilder.setLength(0);
        this.ctx.writeAndFlush((Object)new DefaultHttpContent(byteBuf));
    }

    @Override
    public void close() throws IOException {
        this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        this.callback.responseSendSuccessfully();
    }
}

