/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public final class Http1Writer
implements HttpWriter {
    private final ChannelHandlerContext ctx;

    public Http1Writer(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void writeResponseHeader(HttpRequest request, org.mule.runtime.http.api.domain.message.response.HttpResponse response, ChannelPromise promise) {
        HttpProtocol httpProtocol = request.getProtocol();
        HttpResponse nettyResponse = MuleToNettyUtils.adaptResponseWithoutBody(response, httpProtocol);
        this.ctx.write((Object)nettyResponse);
    }

    @Override
    public void writeContent(ByteBuf content, boolean isLast, ChannelPromise promise) {
        if (isLast) {
            if (content.readableBytes() > 0) {
                this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(content), promise);
            } else {
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise);
            }
        } else {
            this.ctx.writeAndFlush((Object)new DefaultHttpContent(content), promise);
        }
    }
}

