/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpRequest;
import java.io.InputStream;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.netty.impl.message.NettyHttpMessage;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;

public class NettyHttpRequestAdapter
extends NettyHttpMessage
implements org.mule.runtime.http.api.domain.message.request.HttpRequest {
    private static final String PROTOCOL = "http";
    private final InputStream requestContent;
    private HttpEntity body;

    public NettyHttpRequestAdapter(HttpRequest nettyRequest, ServerAddress localAddress, InputStream content) {
        super(nettyRequest, localAddress);
        this.requestContent = content;
    }

    @Override
    protected String getBaseProtocol() {
        return PROTOCOL;
    }

    public HttpEntity getEntity() {
        if (this.body == null) {
            String contentTypeValue = this.getHeaderValue("Content-Type");
            this.body = contentTypeValue != null && contentTypeValue.contains(MediaType.MULTIPART_MIXED.getPrimaryType()) ? (this.contentLength >= 0L ? new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue, this.contentLength) : new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue)) : (this.contentLength > 0L ? new InputStreamHttpEntity(this.requestContent, this.contentLength) : (this.contentLength == 0L ? new EmptyHttpEntity() : new InputStreamHttpEntity(this.requestContent)));
        }
        return this.body;
    }

    public boolean containsHeader(String headerName, String headerValue) {
        if (!this.containsHeader(headerName)) {
            return false;
        }
        for (String connectionHeader : this.getHeaderValues(headerName)) {
            if (!headerValue.equalsIgnoreCase(connectionHeader)) continue;
            return true;
        }
        return false;
    }
}

