/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTextClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpTextClient.class);
    private final Socket socket;
    private StringBuilder response = new StringBuilder();

    public TcpTextClient(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public void sendString(String message) throws IOException {
        this.socket.getOutputStream().write(message.getBytes());
        this.socket.getOutputStream().flush();
    }

    public String receive(int length) throws IOException {
        String resultBeforeRead = this.getResultIfLengthAvailable(length);
        if (resultBeforeRead != null) {
            return resultBeforeRead;
        }
        byte[] buffer = new byte[1024];
        boolean endOfStreamFound = false;
        while (!endOfStreamFound) {
            int actuallyRead = this.socket.getInputStream().read(buffer);
            if (actuallyRead == -1) {
                endOfStreamFound = true;
                continue;
            }
            String asString = new String(buffer, 0, actuallyRead);
            LOGGER.debug("Read (with len) '{}'", (Object)asString);
            this.response.append(asString);
            String result = this.getResultIfLengthAvailable(length);
            if (result == null) continue;
            return result;
        }
        return this.response.toString();
    }

    private String getResultIfLengthAvailable(int length) {
        if (this.response.length() < length) {
            return null;
        }
        String asString = this.response.toString();
        String result = asString.substring(0, length);
        String remaining = asString.substring(length);
        this.response = new StringBuilder(remaining);
        return result;
    }

    public String receiveUntil(String delimiter) throws IOException {
        String resultBeforeRead = this.getResultIfDelimiterFound(delimiter);
        if (resultBeforeRead != null) {
            return resultBeforeRead;
        }
        byte[] buffer = new byte[1024];
        boolean endOfStreamFound = false;
        while (!endOfStreamFound) {
            int actuallyRead = this.socket.getInputStream().read(buffer);
            if (actuallyRead == -1) {
                endOfStreamFound = true;
                continue;
            }
            String asString = new String(buffer, 0, actuallyRead);
            LOGGER.debug("Receiving (with until) '{}'", (Object)asString);
            this.response.append(asString);
            String result = this.getResultIfDelimiterFound(delimiter);
            if (result == null) continue;
            return result;
        }
        String result = this.response.toString();
        this.response = new StringBuilder();
        return result;
    }

    private String getResultIfDelimiterFound(String delimiter) {
        String allReceived = this.response.toString();
        int indexOfDelimiter = allReceived.indexOf(delimiter);
        if (indexOfDelimiter != -1) {
            String result = allReceived.substring(0, indexOfDelimiter);
            String remaining = allReceived.substring(indexOfDelimiter + delimiter.length());
            this.response = new StringBuilder(remaining);
            return result;
        }
        return null;
    }

    public void shutdownWrite() throws IOException {
        this.socket.shutdownOutput();
    }
}

