/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.qameta.allure.Issue;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.test.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-15631402")
public class HttpH2CUpgradeRequestTestCase {
    private static final String RESPONSE = "response";
    private static final String REQUEST = "tests";
    private HttpClient client;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(this.serverPort.getNumber());

    @Before
    public void setUp() {
        this.client = NettyHttpClient.builder().build();
        this.client.start();
    }

    @After
    public void closeClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void whenSettingUpgradeHeaderDoesNotTimeOut() throws Exception {
        Request request = Request.post((String)String.format("http://localhost:%d", this.serverPort.getNumber())).bodyString(new String(REQUEST.getBytes()), ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)).addHeader("Upgrade", "h2c");
        HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()))).build();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)RESPONSE));
    }
}

