/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.Issue;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Issue(value="W-19810563")
public class HttpServerConnectionTimeoutTestCase
extends AbstractHttpServerTestCase {
    private static final int CONNECTION_IDLE_TIMEOUT = 1000;
    private static final String REQUEST_PATH = "/slower-than-idle-connection-timeout";
    private ScheduledExecutorService executorService;

    public HttpServerConnectionTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.setUpServer();
        this.server.addRequestHandler(REQUEST_PATH, (reqCtx, respCb) -> this.executorService.submit(() -> {
            try {
                long longerThanConnectionTimeout = 1100L;
                Thread.sleep(longerThanConnectionTimeout);
                HttpResponse res = HttpResponse.builder().statusCode(Integer.valueOf(200)).build();
                respCb.responseReady(res, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                HttpResponse res = HttpResponse.builder().statusCode(Integer.valueOf(500)).build();
                respCb.responseReady(res, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            }
        }));
    }

    @AfterEach
    void shutdownExecutorService() {
        this.executorService.shutdownNow();
    }

    @Override
    protected String getServerName() {
        return "small-idle-timeout";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setConnectionIdleTimeout(1000);
    }

    @Test
    public void connectionTimeoutShouldNotInterruptInflightRequestProcessing() throws Exception {
        try (CloseableHttpAsyncClient httpClient = HttpAsyncClients.createDefault();){
            httpClient.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(REQUEST_PATH));
            SimpleHttpResponse response = (SimpleHttpResponse)httpClient.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
    }
}

