/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;

public class EmbeddedChannelWithAddress extends EmbeddedChannel {

  private final InetSocketAddress local;
  private final InetSocketAddress remote;

  public EmbeddedChannelWithAddress(InetSocketAddress local, InetSocketAddress remote, ChannelHandler... handlers) {
    super(handlers);
    this.local = local;
    this.remote = remote;
  }

  @Override
  protected SocketAddress localAddress0() {
    return local;
  }

  @Override
  protected SocketAddress remoteAddress0() {
    return remote;
  }
}
