/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils.server;

import java.util.Collection;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.service.http.test.common.util.ReflectiveServiceFactory;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

public class TestHttpServer
extends ExternalResource {
    private static final String TLS_STORES_PASSWORD = "mulepassword";
    private final String host;
    private final int port;
    private final boolean useSsl;
    private HttpServer httpServer;

    public TestHttpServer(String host, int port, boolean useSsl) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
    }

    protected void before() throws Throwable {
        SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
        HttpService httpService = ReflectiveServiceFactory.createHttpService(NettyHttpServiceImplementation.class.getName(), (SchedulerService)schedulerService);
        TlsContextFactory tlsContextFactory = this.useSsl ? TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword(TLS_STORES_PASSWORD).keyPassword(TLS_STORES_PASSWORD).build() : null;
        this.httpServer = httpService.getServerFactory().create(new HttpServerConfiguration.Builder().setName("test-server").setHost(this.host).setPort(this.port).setTlsContextFactory(tlsContextFactory).build());
        this.httpServer.start();
    }

    protected void after() {
        this.httpServer.stop().dispose();
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.httpServer.addRequestHandler(path, requestHandler);
    }

    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.httpServer.addRequestHandler(methods, path, requestHandler);
    }
}

