/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;
import org.mule.service.http.test.netty.tck.CleanBouncyCastleProviders;

@Story(value="TLS")
@Issue(value="MULE-18398")
@CleanBouncyCastleProviders
public class HttpClientTlsCustomProviderTestCase
extends AbstractHttpClientTestCase {
    private static final String PASS = "mulepassword";
    private byte[] dataBytes = "{ 'I am a JSON attachment!' }".getBytes(StandardCharsets.UTF_8);
    private HttpClient client;

    public HttpClientTlsCustomProviderTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    private void ensureBouncyCastleProviders() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), 2);
    }

    @BeforeEach
    public void createClient() throws CreateException {
        this.ensureBouncyCastleProviders();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(TlsContextFactory.builder().trustStorePath("tls/trustStore").trustStorePassword(PASS).build()).setName("multipart-test").build());
        this.client.start();
    }

    @AfterEach
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        try {
            Collection parts = request.getEntity().getParts();
            if (parts.size() == 1 && parts.stream().anyMatch(part -> MediaType.JSON.toRfcString().equals(part.getContentType()))) {
                return ((HttpResponseBuilder)response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).entity((HttpEntity)new ByteArrayHttpEntity(HttpConstants.HttpStatus.OK.getReasonPhrase().getBytes()))).build();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build();
    }

    @Test
    @Description(value="Send request using custom TLS provider (BC).")
    void sendRequestUsingCustomTlsProvider() throws Exception {
        HttpPart part = new HttpPart("someJson", this.dataBytes, MediaType.JSON.toRfcString(), this.dataBytes.length);
        MultipartHttpEntity multipart = new MultipartHttpEntity(Collections.singletonList(part));
        HttpResponse response = this.client.send(((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)multipart)).build(), this.getDefaultOptions(10000));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"OK")));
    }

    @Override
    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return super.getServerConfigurationBuilder().setTlsContextFactory(TlsContextFactory.builder().keyStorePath("tls/serverKeystore").keyStorePassword(PASS).keyPassword(PASS).build());
    }

    @Override
    protected String getUri() {
        return super.getUri().replace(HttpConstants.Protocol.HTTP.getScheme(), HttpConstants.Protocol.HTTPS.getScheme());
    }
}

