/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.client;

import org.mule.weave.v2.el.ByteArrayBasedCursorStreamProvider;

import java.io.InputStream;

import org.junit.jupiter.api.DisplayName;

@DisplayName("Validates that the POST cursor body is preserved on NTLM authentication")
public class CursorNtlmHttpClientPostStreamingTestCase extends AbstractNtlmHttpClientPostStreamingTestCase {

  public CursorNtlmHttpClientPostStreamingTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Override
  protected InputStream getInputStream() {
    return new ByteArrayBasedCursorStreamProvider(TEST_PAYLOAD.getBytes()).doOpenCursor();
  }

}
