/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.DummyRequestHandler;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClientWithBouncyCastle;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyHttpServerWithBouncyCastleTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestHttpServer testServer = new TestHttpServer("localhost", this.serverPort.getNumber(), true);
    @Rule
    public TestSSLNettyClientWithBouncyCastle testClient = new TestSSLNettyClientWithBouncyCastle("localhost", this.serverPort.getNumber());

    @Before
    public void setup() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.testServer.addRequestHandler("/path", new DummyRequestHandler());
        this.testServer.addRequestHandler(Collections.singleton("GET"), "/only-get", new DummyRequestHandler());
    }

    @After
    public void tearDown() {
        Security.removeProvider("BC");
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLConnection() throws Exception {
        String sslEndpoint = "/path";
        HttpResponse response = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((String)"Expected response status code to be 200", (Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLRehandshake() throws Exception {
        String sslEndpoint = "/path";
        HttpResponse initialResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)initialResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.testClient.reHandshake();
        HttpResponse rehandshakeResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)rehandshakeResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLHandshakeFailureWhenKeystorePasswordIsIncorrect() {
        try {
            this.testClient.sendGet("/path");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)"Unable to initialise TLS configuration", (Matcher)Matchers.is((Object)e.getMessage()));
        }
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLHandshakeFailureWhenTrustStorePasswordIsIncorrect() {
        try {
            this.testClient.sendGet("/path");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)"Unable to initialise TLS configuration", (Matcher)Matchers.is((Object)e.getMessage()));
        }
    }
}

