/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Feature(value="HTTP Service")
@Story(value="Listeners")
@Issue(value="W-18538795")
class RequestHandlerConsumingPayloadTestCase
extends AbstractHttpServerTestCase {
    private final CompletableFuture<String> payloadReceivedByServer = new CompletableFuture();

    public RequestHandlerConsumingPayloadTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/", (reqCtx, callback) -> {
            try {
                byte[] bytes = reqCtx.getRequest().getEntity().getBytes();
                this.payloadReceivedByServer.complete(new String(bytes));
                callback.responseReady(HttpResponse.builder().statusCode(Integer.valueOf(200)).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            }
            catch (IOException e) {
                this.payloadReceivedByServer.completeExceptionally(e);
            }
        });
    }

    @Override
    protected String getServerName() {
        return "TestServer";
    }

    @Test
    void consumePayloadSync() throws IOException, ExecutionException, InterruptedException {
        String payload = "Test Payload";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost("http://localhost:" + this.port);
            httpPost.setEntity((HttpEntity)new StringEntity(payload));
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);){
                MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Is.is((Object)200));
                MatcherAssert.assertThat((Object)this.payloadReceivedByServer.get(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)payload)));
            }
        }
    }
}

