/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.util;

import static java.util.Collections.singletonMap;

import org.mule.runtime.http.api.domain.message.MessageWithHeaders;

import java.util.Map;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpMessageHeaderMatcher extends TypeSafeMatcher<MessageWithHeaders> {

  public static Matcher<MessageWithHeaders> hasHeaders(Map<String, String> headers) {
    return new HttpMessageHeaderMatcher(headers);
  }

  public static Matcher<MessageWithHeaders> hasHeader(String headerName, String headerValue) {
    return hasHeaders(singletonMap(headerName, headerValue));
  }

  private final Map<String, String> headers;

  public HttpMessageHeaderMatcher(Map<String, String> headers) {
    this.headers = headers;
  }

  @Override
  protected boolean matchesSafely(MessageWithHeaders item) {
    for (Map.Entry<String, String> expectedHeaderPair : headers.entrySet()) {
      String actual = item.getHeaderValue(expectedHeaderPair.getKey());
      if (!expectedHeaderPair.getValue().equals(actual)) {
        return false;
      }
    }
    return true;
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("Expected an HTTP Message with headers: ").appendValue(headers);
  }

  @Override
  protected void describeMismatchSafely(MessageWithHeaders item, Description mismatchDescription) {
    mismatchDescription.appendText("seen headers ").appendValue(item.getHeaders());
  }
}
