/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

import java.util.concurrent.ExecutorService;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslHandler;

public class ForwardingToListenerInitializer extends ChannelInitializer<Channel> {

  private static final String CONDITIONAL_REQUEST_AGGREGATOR = "Conditional Request Aggregator";
  public static final String FORWARD_TO_HTTP_LISTENER = "Forward to HTTP Listener";
  private final ServerAddress serverAddress;
  private final HttpListenerRegistry httpListenerRegistry;
  private final SslHandler sslHandler;
  private final ExecutorService ioExecutor;

  public ForwardingToListenerInitializer(ServerAddress serverAddress,
                                         HttpListenerRegistry httpListenerRegistry,
                                         SslHandler sslHandler,
                                         ExecutorService ioExecutor) {
    this.serverAddress = serverAddress;
    this.httpListenerRegistry = httpListenerRegistry;
    this.sslHandler = sslHandler;
    this.ioExecutor = ioExecutor;
  }

  @Override
  public void initChannel(Channel channel) {
    channel.pipeline().addLast(CONDITIONAL_REQUEST_AGGREGATOR, new ConditionalRequestAggregator());
    channel.pipeline().addLast(FORWARD_TO_HTTP_LISTENER,
                               new ForwardingToListenerHandler(serverAddress, httpListenerRegistry, sslHandler, ioExecutor));
  }
}
