/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.util;

import java.io.InputStream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

public final class HttpEntityMatcher
extends TypeSafeMatcher<HttpEntity> {
    private final Matcher<String> contentStringMatcher;

    public static Matcher<HttpEntity> hasContent(Matcher<String> contentStringMatcher) {
        return new HttpEntityMatcher(contentStringMatcher);
    }

    private HttpEntityMatcher(Matcher<String> contentStringMatcher) {
        this.contentStringMatcher = contentStringMatcher;
    }

    protected boolean matchesSafely(HttpEntity item) {
        String contentAsString = IOUtils.toString((InputStream)item.getContent());
        return this.contentStringMatcher.matches((Object)contentAsString);
    }

    public void describeTo(Description description) {
        description.appendText("A content matching: ");
        this.contentStringMatcher.describeTo(description);
    }

    protected void describeMismatchSafely(HttpEntity item, Description mismatchDescription) {
        String contentAsString = IOUtils.toString((InputStream)item.getContent());
        mismatchDescription.appendText("Content was: '").appendText(contentAsString).appendText("'");
    }
}

