/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.service.http.netty.impl.server.FinishStreamingListener;
import org.mule.service.http.netty.impl.server.SendNextChunkListener;
import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingEntitySender {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingEntitySender.class);
    public static final int ENTITY_STREAMING_BUFFER_SIZE = 8192;
    private static final int END_OF_STREAM = -1;
    private final ChannelHandlerContext ctx;
    private final int bufferSize;
    private final Runnable beforeWrite;
    private final StatusCallback statusCallback;
    private final InputStream contentAsInputStream;
    private final OptionalLong entityLength;
    private final AtomicLong bytesAlreadySent;
    private final long initialNanos;
    private final AtomicBoolean isAlreadyScheduledToIO;
    private final ExecutorService ioExecutor;

    public StreamingEntitySender(HttpEntity entity, ChannelHandlerContext ctx, Runnable beforeWrite, StatusCallback statusCallback, ExecutorService ioExecutor) {
        this.ctx = ctx;
        this.contentAsInputStream = entity.getContent();
        this.entityLength = entity.getBytesLength();
        this.bufferSize = this.calculateBufferSize();
        this.beforeWrite = beforeWrite;
        this.statusCallback = statusCallback;
        this.bytesAlreadySent = new AtomicLong(0L);
        this.initialNanos = System.nanoTime();
        this.isAlreadyScheduledToIO = new AtomicBoolean(false);
        this.ioExecutor = ioExecutor;
    }

    public void sendNextChunk() throws IOException {
        byte[] buf;
        int bytesActuallyRead;
        if (this.bufferSize == 0) {
            this.sendEmptyContentAndFinish(this.contentAsInputStream);
            return;
        }
        if (this.shouldScheduleNextChunkToIO()) {
            boolean couldScheduleToIO = this.tryScheduleNextChunkHandlingToIO();
            if (couldScheduleToIO) {
                return;
            }
            LOGGER.debug("Tried to schedule next chunk handling to IO, but the task was rejected. It will be executed in the current thread.");
        }
        if (-1 == (bytesActuallyRead = StreamingEntitySender.readChunk(this.contentAsInputStream, buf = new byte[this.bufferSize]))) {
            this.sendEmptyContentAndFinish(this.contentAsInputStream);
        } else {
            ByteBuf content = this.createBuffer(bytesActuallyRead);
            content.writeBytes(buf, 0, bytesActuallyRead);
            if (this.weKnowItIsTheLastChunk(bytesActuallyRead, this.bytesAlreadySent.get())) {
                this.sendBufferWithPromise((HttpContent)new DefaultLastHttpContent(content), this.finishStreamingPromise(this.contentAsInputStream));
            } else {
                this.sendBufferWithPromise((HttpContent)new DefaultHttpContent(content), this.sendNextChunkPromise());
            }
            this.bytesAlreadySent.addAndGet(bytesActuallyRead);
        }
    }

    private boolean shouldScheduleNextChunkToIO() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initialNanos) >= 50L && !this.isAlreadyScheduledToIO.get();
    }

    private boolean tryScheduleNextChunkHandlingToIO() {
        try {
            this.ioExecutor.execute(() -> {
                try {
                    LOGGER.debug("Scheduling next chunk handling to IO");
                    this.sendNextChunk();
                }
                catch (IOException e) {
                    this.statusCallback.onFailure(e);
                }
            });
            this.isAlreadyScheduledToIO.set(true);
            return true;
        }
        catch (RejectedExecutionException ree) {
            return false;
        }
    }

    private boolean weKnowItIsTheLastChunk(int bytesToSend, long bytesAlreadySent) {
        if (!this.entityLength.isPresent()) {
            return false;
        }
        return bytesAlreadySent + (long)bytesToSend >= this.entityLength.getAsLong();
    }

    private int calculateBufferSize() {
        return Math.min(Math.toIntExact(this.entityLength.orElse(8192L)), 8192);
    }

    private ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    private ChannelPromise createPromise(ChannelFutureListener listener) {
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener((GenericFutureListener)listener);
        return promise;
    }

    private void sendEmptyContentAndFinish(InputStream contentAsInputStream) {
        this.beforeWrite.run();
        this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.finishStreamingPromise(contentAsInputStream));
    }

    private ChannelPromise finishStreamingPromise(InputStream stream) {
        return this.createPromise(new FinishStreamingListener(stream, this.statusCallback));
    }

    private ChannelPromise sendNextChunkPromise() {
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener((GenericFutureListener)new SendNextChunkListener(this, this.statusCallback));
        return promise;
    }

    private void sendBufferWithPromise(HttpContent content, ChannelPromise promise) {
        this.beforeWrite.run();
        this.ctx.writeAndFlush((Object)content, promise);
    }

    private static int readChunk(InputStream contentAsInputStream, byte[] buf) throws IOException {
        try {
            return contentAsInputStream.read(buf);
        }
        catch (IllegalStateException exception) {
            if ("Buffer is closed".equals(exception.getMessage())) {
                return -1;
            }
            throw exception;
        }
    }
}

