/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.netty.impl.streaming.BidirectionalByteBufferStream;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class BidirectionalByteBufferTestCase
extends AbstractMuleTestCase {
    @Test
    public void readFromEmpty() throws IOException {
        byte[] aux = new byte[5];
        BidirectionalByteBufferStream empty = new BidirectionalByteBufferStream();
        int result = empty.read(aux, 0, 5);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void writeOneChunk_readOneChunk() throws IOException {
        byte[] toWrite = "Hello world".getBytes(StandardCharsets.UTF_8);
        byte[] readBytes = "____________________".getBytes(StandardCharsets.UTF_8);
        BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
        bidiBuf.write(toWrite, 0, toWrite.length);
        int result = bidiBuf.read(readBytes, 0, toWrite.length);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)toWrite.length));
        MatcherAssert.assertThat((Object)new String(readBytes), (Matcher)Matchers.is((Object)"Hello world_________"));
    }

    @Test
    public void writeOneChunk_readTwoChunks() throws IOException {
        byte[] toWrite = "Hello world".getBytes(StandardCharsets.UTF_8);
        byte[] readBytes = "____________________".getBytes(StandardCharsets.UTF_8);
        BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
        bidiBuf.write(toWrite, 0, toWrite.length);
        int result1 = bidiBuf.read(readBytes, 0, 5);
        int result2 = bidiBuf.read(readBytes, 5, toWrite.length - 5);
        MatcherAssert.assertThat((Object)result1, (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.is((Object)(toWrite.length - 5)));
        MatcherAssert.assertThat((Object)new String(readBytes), (Matcher)Matchers.is((Object)"Hello world_________"));
    }

    @Test
    public void writeTwoChunks_readOneChunk() throws IOException {
        byte[] toWrite = "Hello world".getBytes(StandardCharsets.UTF_8);
        byte[] readBytes = "____________________".getBytes(StandardCharsets.UTF_8);
        BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
        bidiBuf.write(toWrite, 0, 5);
        bidiBuf.write(toWrite, 5, toWrite.length - 5);
        int result = bidiBuf.read(readBytes, 0, toWrite.length);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)toWrite.length));
        MatcherAssert.assertThat((Object)new String(readBytes), (Matcher)Matchers.is((Object)"Hello world_________"));
    }

    @Test
    public void writeTwoChunks_readTwoChunks() throws IOException {
        byte[] toWrite = "Hello world".getBytes(StandardCharsets.UTF_8);
        byte[] readBytes = "____________________".getBytes(StandardCharsets.UTF_8);
        BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
        bidiBuf.write(toWrite, 0, 5);
        bidiBuf.write(toWrite, 5, toWrite.length - 5);
        int result1 = bidiBuf.read(readBytes, 0, 6);
        int result2 = bidiBuf.read(readBytes, 6, toWrite.length - 6);
        MatcherAssert.assertThat((Object)result1, (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.is((Object)(toWrite.length - 6)));
        MatcherAssert.assertThat((Object)new String(readBytes), (Matcher)Matchers.is((Object)"Hello world_________"));
    }
}

