/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.service.http.netty.impl.server.HttpWithAPNServerHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class HttpWithAPNServerHandlerTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private HackyHttpWithAPNServerHandler handler;
    @Spy
    private BiConsumer<ChannelPipeline, SslHandler> mockHttp1Consumer;

    @Before
    public void setUp() {
        this.handler = new HackyHttpWithAPNServerHandler(this.mockHttp1Consumer);
    }

    @Test
    public void filtersOutHttp_1_0_Requests() {
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.handler.configure("http/1.0"));
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((String)"Unknown protocol: http/1.0"));
    }

    @Test
    public void callsHttp_1_1_Consumer() throws Exception {
        this.handler.configure("http/1.1");
        ((BiConsumer)Mockito.verify(this.mockHttp1Consumer)).accept((ChannelPipeline)ArgumentMatchers.any(), (SslHandler)ArgumentMatchers.any());
    }

    private static class HackyHttpWithAPNServerHandler
    extends HttpWithAPNServerHandler {
        HackyHttpWithAPNServerHandler(BiConsumer<ChannelPipeline, SslHandler> http1Configurer) {
            super(http1Configurer, null);
        }

        void configure(String protocol) throws Exception {
            this.configurePipeline((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), protocol);
        }
    }
}

