/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.TestHttp2RequestHandler;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClient;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyHttpServerTestCase
extends AbstractMuleTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestSSLNettyClient testClient = new TestSSLNettyClient("localhost", this.serverPort.getNumber());
    private HttpServer server;
    private RequestHandlerManager requestHandlerManager;
    private HttpListenerRegistry listenerRegistry;

    @Before
    public void setup() throws IOException, NoSuchAlgorithmException, CreateException, KeyManagementException {
        this.listenerRegistry = new HttpListenerRegistry();
        SslContext serverSslContext = TestUtils.createServerSslContext();
        int maxHeaderSectionSize = 300;
        this.server = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).withSslContext(serverSslContext).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.listenerRegistry, true, 30000, 10000L, serverSslContext, maxHeaderSectionSize, executorRule.getExecutor())).build();
        this.server.start();
        this.requestHandlerManager = this.server.addRequestHandler("/path", (RequestHandler)new TestHttp2RequestHandler());
        this.server.addRequestHandler(Collections.singleton("GET"), "/only-get", (RequestHandler)new TestHttp2RequestHandler());
    }

    @After
    public void tearDown() {
        this.server.stop().dispose();
    }

    @Test
    public void sendRequestToWrongPathResultsInAResponseWithStatusNotFound() throws ExecutionException, InterruptedException, IOException {
        HttpResponse notFoundResponse = this.testClient.sendGet("/not-existent");
        MatcherAssert.assertThat((Object)notFoundResponse.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void twoSimpleGetRequestsToTheSamePathAreRespondedCorrectly() throws IOException, ExecutionException, InterruptedException {
        HttpResponse response1 = this.testClient.sendGet("/path");
        String responseAsString1 = IOUtils.toString((InputStream)response1.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response1.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString1, (Matcher)Matchers.is((Object)"Test body"));
        HttpResponse response2 = this.testClient.sendGet("/path");
        String responseAsString2 = IOUtils.toString((InputStream)response2.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response2.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString2, (Matcher)Matchers.is((Object)"Test body"));
    }

    @Test
    public void simpleGetRequestWithInvalidHeaders() throws IOException, ExecutionException, InterruptedException {
        MultiMap.StringMultiMap headers = new MultiMap.StringMultiMap();
        headers.put((Object)"x-authentication-properties", (Object)"{\n\"key1\":\"value\"\n}");
        HttpResponse response1 = this.testClient.sendGet("/path", (MultiMap<String, String>)headers);
        String responseAsString1 = IOUtils.toString((InputStream)response1.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response1.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString1, (Matcher)Matchers.is((Object)"Test body"));
    }

    @Test
    public void ifTheRequestHandlerIsStoppedThenWeExpectA503() throws ExecutionException, InterruptedException {
        this.requestHandlerManager.stop();
        HttpResponse response = this.testClient.sendGet("/path");
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode()));
    }

    @Test
    public void ifTheRequestHandlerIsDisposedThenWeExpectA404() throws ExecutionException, InterruptedException {
        this.requestHandlerManager.dispose();
        HttpResponse notFoundResponse = this.testClient.sendGet("/path");
        MatcherAssert.assertThat((Object)notFoundResponse.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void twoSimplePostRequestsToTheSamePathAreRespondedCorrectly() throws IOException, ExecutionException, InterruptedException {
        HttpResponse response1 = this.testClient.sendPost("/path", "This is a Request");
        String responseAsString1 = IOUtils.toString((InputStream)response1.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response1.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString1, (Matcher)Matchers.is((Object)"Test body"));
        HttpResponse response2 = this.testClient.sendPost("/path", "This is a Request");
        String responseAsString2 = IOUtils.toString((InputStream)response2.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response2.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString2, (Matcher)Matchers.is((Object)"Test body"));
    }

    @Test
    public void sendGetToOnlyGetEndpoint() throws ExecutionException, InterruptedException, IOException {
        HttpResponse response = this.testClient.sendGet("/only-get");
        String responseAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString, (Matcher)Matchers.is((Object)"Test body"));
    }

    @Test
    public void sendPostToOnlyGetEndpoint() throws ExecutionException, InterruptedException, IOException {
        HttpResponse response = this.testClient.sendPost("/only-get", "Test payload");
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.METHOD_NOT_ALLOWED.getStatusCode()));
    }

    @Test
    @Issue(value="W-15816690")
    public void serverWithSslContextReturnsHttpsAsProtocol() throws NoSuchAlgorithmException, CreateException, KeyManagementException {
        SslContext serverSslContext = TestUtils.createServerSslContext();
        HttpServer serverWithSslContext = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).withSslContext(serverSslContext).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.listenerRegistry, true, 30000, 10000L, serverSslContext, executorRule.getExecutor())).build();
        MatcherAssert.assertThat((Object)serverWithSslContext.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
    }

    @Test
    @Issue(value="W-15816690")
    public void serverWithoutSslContextReturnsHttpAsProtocol() {
        HttpServer serverWithoutSslContext = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.listenerRegistry, true, 30000, 10000L, null, executorRule.getExecutor())).build();
        MatcherAssert.assertThat((Object)serverWithoutSslContext.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
    }

    @Test
    @Issue(value="W-15867819")
    public void nonStartedServerDoesNotFailWithNPEToAddARequestHandler() {
        HttpServer notStartedServer = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withShutdownTimeout(() -> 5000L).withHttpListenerRegistry(this.listenerRegistry).build();
        RequestHandlerManager manager = notStartedServer.addRequestHandler("/testPath", (requestContext, responseCallback) -> {});
        MatcherAssert.assertThat((Object)manager, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    @Issue(value="W-15631509")
    public void getRequestWithTooLargeEntityReturns413() throws IOException, ExecutionException, InterruptedException {
        MultiMap.StringMultiMap headers = new MultiMap.StringMultiMap();
        for (int i = 1; i <= 20; ++i) {
            headers.put((Object)("testheader" + i), (Object)("testvalue" + i));
        }
        HttpResponse response = this.testClient.sendGet("/path", (MultiMap<String, String>)headers);
        String responseAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_TOO_LONG.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString, (Matcher)Matchers.containsString((String)"Request entity too large"));
    }

    @Test
    @Issue(value="W-15631509")
    public void getRequestWithLongUriReturnsDetailed414() throws IOException, ExecutionException, InterruptedException {
        char[] chars = new char[310];
        Arrays.fill(chars, 'A');
        String longUri = "/path" + new String(chars);
        HttpResponse response = this.testClient.sendGet(longUri);
        String responseAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_URI_TOO_LONG.getStatusCode()));
        MatcherAssert.assertThat((Object)responseAsString, (Matcher)Matchers.containsString((String)"Request too long"));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLConnection() throws Exception {
        String sslEndpoint = "/path";
        HttpResponse response = this.testClient.sendGet(sslEndpoint);
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Expected response status code to be 200", (Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Expected response body", (Object)responseBody, (Matcher)Matchers.is((Object)"Test body"));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLRehandshake() throws Exception {
        String sslEndpoint = "/path";
        HttpResponse initialResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)initialResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.testClient.reHandshake();
        HttpResponse rehandshakeResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)rehandshakeResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }
}

