/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.netty.impl.server.ConnectionsCounterHandler;
import org.mule.service.http.netty.impl.server.ForwardingToListenerInitializer;
import org.mule.service.http.netty.impl.server.HttpWithAPNServerHandler;
import org.mule.service.http.netty.impl.server.KeepAliveHandler;
import org.mule.service.http.netty.impl.server.MuleHttpServerExpectContinueHandler;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;

public class AcceptedConnectionChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    public static final String FLUSH_CONSOLIDATION_HANDLER_NAME = "flushConsolidationHandler";
    private final SslContext sslContext;
    private final HttpListenerRegistry httpListenerRegistry;
    private final boolean usePersistentConnections;
    private final long connectionIdleTimeout;
    private final long readTimeout;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final ConnectionsCounterHandler connectionsCountHandler;
    private final ExecutorService ioExecutor;

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, HttpServerConfiguration configuration, SslContext sslContext, ExecutorService ioExecutor) {
        this(httpListenerRegistry, configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), configuration.getReadTimeout(), sslContext, ioExecutor);
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, ExecutorService ioExecutor) {
        this(httpListenerRegistry, usePersistentConnections, connectionIdleTimeout, readTimeout, sslContext, AcceptedConnectionChannelInitializer.retrieveMaximumHeaderSectionSize(), ioExecutor);
    }

    AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, int maxHeaderSectionSize, ExecutorService ioExecutor) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.readTimeout = readTimeout;
        this.sslContext = sslContext;
        this.maxInitialLineLength = maxHeaderSectionSize;
        this.maxHeaderSize = maxHeaderSectionSize;
        this.connectionsCountHandler = new ConnectionsCounterHandler();
        this.ioExecutor = ioExecutor;
    }

    protected void initChannel(SocketChannel socketChannel) {
        socketChannel.pipeline().addFirst(FLUSH_CONSOLIDATION_HANDLER_NAME, (ChannelHandler)new FlushConsolidationHandler(256, true));
        socketChannel.pipeline().addFirst(new ChannelHandler[]{this.connectionsCountHandler});
        this.configureTimeouts(socketChannel);
        if (null != this.sslContext) {
            this.configureWithSslAndAPN((Channel)socketChannel);
        } else {
            this.configureHttp1(socketChannel.pipeline(), null);
        }
    }

    public void waitForConnectionsToBeClosed(Long timeout, TimeUnit timeUnit) {
        this.connectionsCountHandler.waitForConnectionsToBeClosed(timeout, timeUnit);
    }

    private void configureWithSslAndAPN(Channel channel) {
        SslHandler sslHandler = this.sslContext.newHandler(channel.alloc());
        channel.pipeline().addLast("SSL Handler", (ChannelHandler)sslHandler).addLast("Protocol Negotiation Handler", (ChannelHandler)new HttpWithAPNServerHandler(this::configureHttp1, sslHandler));
    }

    private void configureTimeouts(SocketChannel socketChannel) {
        if (this.connectionIdleTimeout != -1L || this.readTimeout != -1L) {
            socketChannel.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(this.readTimeout, this.connectionIdleTimeout, this.connectionIdleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    protected void configureHttp1(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast("Logging Handler", (ChannelHandler)new HttpLoggingHandler());
        pipeline.addLast("HTTP/1 Codec", (ChannelHandler)new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, 8192));
        pipeline.addLast("Expect Continue Handler", (ChannelHandler)new MuleHttpServerExpectContinueHandler());
        pipeline.addLast("Keep Alive", (ChannelHandler)new KeepAliveHandler(this.usePersistentConnections));
        pipeline.addLast("Forward Initializer", (ChannelHandler)new ForwardingToListenerInitializer(this.httpListenerRegistry, sslHandler, this.ioExecutor));
    }

    private static int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.parseInt(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }
}

