/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.MatcherCollisionException;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistry;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class RequestMatcherRegistryTestCase
extends AbstractMuleTestCase {
    private static final Object METHOD_MISMATCH = new Object();
    private static final Object NOT_FOUND = new Object();
    private static final Object DISABLED = new Object();
    private static final Object SECOND_LEVEL_CATCH_ALL = new Object();
    private static final Object SECOND_LEVEL_SPECIFIC = new Object();
    private static final Object FIRST_LEVEL_SPECIFIC = new Object();
    private DefaultRequestMatcherRegistry<Object> registry;
    private Object handler;

    @Test
    public void testAddPath() {
        this.resetRegistryAndHandler();
        PathAndMethodRequestMatcher rootMatcher = PathAndMethodRequestMatcher.builder().path("/").build();
        this.registry.add(rootMatcher, this.handler);
        MatcherAssert.assertThat((Object)this.registry.find(HttpRequest.builder().uri("http://localhost:8081/").method(HttpConstants.Method.GET).build()), (Matcher)Matchers.is((Object)this.handler));
        this.resetRegistryAndHandler();
        PathAndMethodRequestMatcher wildcardMatcher = PathAndMethodRequestMatcher.builder().path("/*").build();
        this.registry.add(wildcardMatcher, this.handler);
        MatcherAssert.assertThat((Object)this.registry.find(HttpRequest.builder().uri("http://localhost:8081/any/path").method(HttpConstants.Method.GET).build()), (Matcher)Matchers.is((Object)this.handler));
        this.resetRegistryAndHandler();
        PathAndMethodRequestMatcher specificMatcher = PathAndMethodRequestMatcher.builder().path("/foo/bar").build();
        this.registry.add(specificMatcher, this.handler);
        MatcherAssert.assertThat((Object)this.registry.find(HttpRequest.builder().uri("http://localhost:8081/foo/bar").method(HttpConstants.Method.GET).build()), (Matcher)Matchers.is((Object)this.handler));
    }

    @Test
    public void testAddMultipleMethods() {
        this.resetRegistryAndHandler();
        PathAndMethodRequestMatcher matcher = PathAndMethodRequestMatcher.builder().path("/foo").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).add(HttpConstants.Method.POST).build()).build();
        this.registry.add(matcher, this.handler);
        HttpRequest getRequest = HttpRequest.builder().uri("http://localhost:8081/foo").method(HttpConstants.Method.GET).build();
        Object getResult = this.registry.find(getRequest);
        HttpRequest postRequest = HttpRequest.builder().uri("http://localhost:8081/foo").method(HttpConstants.Method.POST).build();
        Object postResult = this.registry.find(postRequest);
        MatcherAssert.assertThat((Object)getResult, (Matcher)Matchers.is((Object)this.handler));
        MatcherAssert.assertThat((Object)postResult, (Matcher)Matchers.is((Object)this.handler));
    }

    @Test
    public void findByRequest() {
        this.registry = this.buildRegistry(this.getFullBuilder());
        this.validateRequestMatch(this.registry, "/path/somewhere", SECOND_LEVEL_CATCH_ALL);
        this.validateRequestMatch(this.registry, "/path/here", SECOND_LEVEL_SPECIFIC);
        this.validateRequestMatch(this.registry, "/here", DISABLED);
        this.validateRequestMatch(this.registry, "/nope", NOT_FOUND);
        this.validateRequestMatch(this.registry, "/path/somewhere", Matchers.sameInstance((Object)METHOD_MISMATCH), HttpConstants.Method.POST);
    }

    @Test
    public void allNullIfDefault() {
        this.registry = this.buildRegistry((DefaultRequestMatcherRegistryBuilder<Object>)new DefaultRequestMatcherRegistryBuilder());
        this.validateMethodAndPathMatch(this.registry, "/path/somewhere", SECOND_LEVEL_CATCH_ALL);
        this.validateMethodAndPathMatch(this.registry, "/path/here", SECOND_LEVEL_SPECIFIC);
        this.validateMethodAndPathMatch(this.registry, "/here", Matchers.nullValue(), HttpConstants.Method.GET);
        this.validateMethodAndPathMatch(this.registry, "/nope", Matchers.nullValue(), HttpConstants.Method.GET);
        this.validateMethodAndPathMatch(this.registry, "/path/somewhere", Matchers.nullValue(), HttpConstants.Method.POST);
    }

    @Test
    public void testFindCatchAllWithMethod() {
        this.registry = new DefaultRequestMatcherRegistry();
        Object catchAllGetHandler = new Object();
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/*").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build(), catchAllGetHandler);
        HttpRequest request1 = HttpRequest.builder().uri("http://localhost:8081/some/path").method(HttpConstants.Method.GET).build();
        Object result1 = this.registry.find(request1);
        MatcherAssert.assertThat((Object)result1, (Matcher)Matchers.is((Object)catchAllGetHandler));
        HttpRequest request2 = HttpRequest.builder().uri("http://localhost:8081/some/path").method(HttpConstants.Method.POST).build();
        Object result2 = this.registry.find(request2);
        MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testFindRootPathWithTrailingSlash() {
        this.registry = this.buildRegistry(this.getFullBuilder());
        Object rootHandler = new Object();
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/").build(), rootHandler);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:8081/").method(HttpConstants.Method.GET).build();
        Object result = this.registry.find(request);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)rootHandler));
    }

    @Test
    public void testPathDecodedWithEncodedSlashes() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.encoded.slash.enabled", (Object)"true", () -> {
            this.resetRegistryAndHandler();
            String encodedPath = "/foo%2Fbar%2Fbaz";
            String decodedPath = "/foo/bar/baz";
            this.registry.add(PathAndMethodRequestMatcher.builder().path(decodedPath).build(), this.handler);
            HttpRequest request = HttpRequest.builder().uri("http://localhost:8081" + encodedPath).method(HttpConstants.Method.GET).build();
            Object result = this.registry.find(request);
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.handler));
        });
    }

    @Test
    public void testPathDecodedWithEncodedSlashesWithNoEncodedSlashes() {
        this.resetRegistryAndHandler();
        String path = "/foo/bar/baz";
        this.registry.add(PathAndMethodRequestMatcher.builder().path(path).build(), this.handler);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:8081" + path).method(HttpConstants.Method.GET).build();
        Object result = this.registry.find(request);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.handler));
    }

    @Test
    public void testPathDecodedWithEncodedSlashesWithSingleEncodedSlash() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.encoded.slash.enabled", (Object)"true", () -> {
            this.resetRegistryAndHandler();
            String decodedPath = "/foo/bar";
            String encodedPath = "/foo%2Fbar";
            this.registry.add(PathAndMethodRequestMatcher.builder().path(decodedPath).build(), this.handler);
            HttpRequest request = HttpRequest.builder().uri("http://localhost:8081" + encodedPath).method(HttpConstants.Method.GET).build();
            Object result = this.registry.find(request);
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.handler));
        });
    }

    @Test
    public void testPathDecodedWithEncodedSlashesWithEncodedSlashes() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.encoded.slash.enabled", (Object)"true", () -> {
            this.registry = new DefaultRequestMatcherRegistry();
            String encodedPath = "/foo%2Fbar%2Fbaz";
            String decodedPath = this.registry.pathDecodedWithEncodedSlashes(encodedPath);
            MatcherAssert.assertThat((Object)decodedPath, (Matcher)Matchers.is((Object)"/foo%2Fbar%2Fbaz"));
        });
    }

    @Test
    public void testRemoveCatchAllPath() {
        this.registry = this.buildRegistry(this.getFullBuilder());
        RequestMatcherRegistry.RequestMatcherRegistryEntry entry = this.registry.add(PathAndMethodRequestMatcher.builder().path("/foo/*").build(), new Object());
        entry.remove();
        this.validateRequestMatch(this.registry, "/foo/bar", NOT_FOUND);
    }

    @Test
    public void testRemoveUriParameterPath() {
        this.registry = this.buildRegistry(this.getFullBuilder());
        RequestMatcherRegistry.RequestMatcherRegistryEntry entry = this.registry.add(PathAndMethodRequestMatcher.builder().path("/foo/{param}").build(), new Object());
        entry.remove();
        this.validateRequestMatch(this.registry, "/foo/bar", NOT_FOUND);
    }

    @Test
    public void testRemoveFromCatchAllUriParam() throws Exception {
        DefaultRequestMatcherRegistry.Path path = new DefaultRequestMatcherRegistry.Path("test", null);
        PathAndMethodRequestMatcher matcher = PathAndMethodRequestMatcher.builder().path("/{param}").build();
        DefaultRequestMatcherRegistry.RequestHandlerMatcherPair pair = new DefaultRequestMatcherRegistry.RequestHandlerMatcherPair(matcher, new Object());
        path.addChildPath("{param}", new DefaultRequestMatcherRegistry.Path("{param}", path));
        path.getCatchAllUriParam().addRequestHandlerMatcherPair(pair);
        boolean removed = path.removeRequestHandlerMatcherPair(pair);
        MatcherAssert.assertThat((Object)removed, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)path.getCatchAllUriParam(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testRemoveChildPath() {
        DefaultRequestMatcherRegistry.Path root = new DefaultRequestMatcherRegistry.Path("root", null);
        DefaultRequestMatcherRegistry.Path child = new DefaultRequestMatcherRegistry.Path("child", root);
        root.addChildPath("child", child);
        root.removeChildPath("child");
        MatcherAssert.assertThat((Object)root.getSubPaths().containsKey("child"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testMatchesNextSubPaths() {
        DefaultRequestMatcherRegistry.Path path = new DefaultRequestMatcherRegistry.Path("root", null);
        path.addChildPath("{param}", new DefaultRequestMatcherRegistry.Path("{param}", path));
        path.getCatchAllUriParam().addChildPath("other", new DefaultRequestMatcherRegistry.Path("other", path.getCatchAllUriParam()));
        path.addChildPath("segment1", new DefaultRequestMatcherRegistry.Path("segment1", path));
        DefaultRequestMatcherRegistry.Path result = path.getChildPath("segment1", "other");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)path.getCatchAllUriParam()));
    }

    @Test
    public void testDefaultConstructor() {
        this.registry = new DefaultRequestMatcherRegistry();
        MatcherAssert.assertThat(this.registry, (Matcher)Matchers.notNullValue());
    }

    @Test(expected=MatcherCollisionException.class)
    public void testValidateCollision() {
        this.registry = new DefaultRequestMatcherRegistry();
        PathAndMethodRequestMatcher matcher1 = PathAndMethodRequestMatcher.builder().path("/test").build();
        this.registry.add(matcher1, new Object());
        PathAndMethodRequestMatcher matcher2 = PathAndMethodRequestMatcher.builder().path("/test").build();
        this.registry.add(matcher2, new Object());
    }

    @Test(expected=MatcherCollisionException.class)
    public void testCatchAllVsCatchAllSameMethod() {
        this.registry = new DefaultRequestMatcherRegistry();
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/*").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build(), new Object());
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/*").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build(), new Object());
    }

    @Test(expected=MatcherCollisionException.class)
    public void testUriParameterVsUriParameter() {
        this.registry = new DefaultRequestMatcherRegistry();
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/{param1}").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build(), new Object());
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/{param2}").methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build(), new Object());
    }

    private DefaultRequestMatcherRegistry<Object> buildRegistry(DefaultRequestMatcherRegistryBuilder<Object> builder) {
        this.registry = (DefaultRequestMatcherRegistry)builder.build();
        this.registry.add(PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).path("/path/*").build(), SECOND_LEVEL_CATCH_ALL);
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/path/here").build(), SECOND_LEVEL_SPECIFIC);
        this.registry.add(PathAndMethodRequestMatcher.builder().path("/here").build(), FIRST_LEVEL_SPECIFIC).disable();
        return this.registry;
    }

    private DefaultRequestMatcherRegistryBuilder<Object> getFullBuilder() {
        return (DefaultRequestMatcherRegistryBuilder)new DefaultRequestMatcherRegistryBuilder().onMethodMismatch(() -> METHOD_MISMATCH).onNotFound(() -> NOT_FOUND).onDisabled(() -> DISABLED);
    }

    private void validateRequestMatch(DefaultRequestMatcherRegistry<Object> registry, String path, Object expectedItem) {
        this.validateRequestMatch(registry, path, Matchers.sameInstance((Object)expectedItem), HttpConstants.Method.GET);
    }

    private void validateRequestMatch(DefaultRequestMatcherRegistry<Object> registry, String path, Matcher matcher, HttpConstants.Method method) {
        MatcherAssert.assertThat((Object)registry.find(HttpRequest.builder().uri(String.format("http://localhost:8081%s", path)).method(method).build()), (Matcher)Matchers.is((Matcher)matcher));
    }

    private void validateMethodAndPathMatch(DefaultRequestMatcherRegistry<Object> registry, String path, Object expectedItem) {
        this.validateMethodAndPathMatch(registry, path, Matchers.sameInstance((Object)expectedItem), HttpConstants.Method.GET);
    }

    private void validateMethodAndPathMatch(DefaultRequestMatcherRegistry<Object> registry, String path, Matcher matcher, HttpConstants.Method method) {
        MatcherAssert.assertThat((Object)registry.find(method.name(), path), (Matcher)Matchers.is((Matcher)matcher));
    }

    private void resetRegistryAndHandler() {
        this.registry = new DefaultRequestMatcherRegistry();
        this.handler = new Object();
    }
}

