/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.tck.ExecutorRule;
import org.mule.service.http.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.netty.utils.TcpTextClient;
import org.mule.service.http.netty.utils.TestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-17464403")
public class ServerConnectionTimeoutTestCase
extends AbstractMuleTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private static final int SMALL_CONNECTION_TIMEOUT_MILLIS = 500;
    private static final long LARGE_READ_TIMEOUT_MILLIS = 1000000L;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private HttpServer httpServer;

    @Before
    public void setup() throws Exception {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        this.httpServer = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, true, 500, 1000000L, null, 300, executorRule.getExecutor())).build();
        this.httpServer.start();
        this.httpServer.addRequestHandler("/test", (requestContext, responseCallback) -> executorRule.getExecutor().submit(() -> {
            String asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent());
            responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }));
    }

    @After
    public void tearDown() {
        if (!this.httpServer.isStopped()) {
            this.httpServer.stop();
        }
        this.httpServer.dispose();
    }

    @Test
    public void sendPartialRequestShouldTimeout() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.serverPort.getNumber());){
            tcpTextClient.sendString("GET /test HTTP/1.1\nHost: localhost: %s\n\n".formatted(this.serverPort.getNumber()));
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 200 OK\ncontent-length: 0"));
            tcpTextClient.sendString("GET /test HTTP/1.1\nHost: localhost: %d\n\n".formatted(this.serverPort.getNumber()));
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 200 OK\ncontent-length: 0"));
            long elapsedNanos = TestUtils.measuringNanoseconds(() -> {
                String content = tcpTextClient.receiveUntil("\r\n\r\n");
                MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)""));
            });
            long toleranceNanos = TimeUnit.MILLISECONDS.toNanos(50L);
            long connectionTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(500L);
            MatcherAssert.assertThat((Object)elapsedNanos, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(connectionTimeoutNanos + toleranceNanos))));
        }
    }
}

