/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public final class MuleToNettyUtils {
    private static final Set<String> DEFAULT_EMPTY_BODY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS")));

    private MuleToNettyUtils() {
    }

    public static HttpResponse adaptResponseWithoutBody(org.mule.runtime.http.api.domain.message.response.HttpResponse muleResponse, HttpProtocol httpProtocol) {
        HttpVersion httpVersion = MuleToNettyUtils.toNettyHttpVersion(httpProtocol);
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(Objects.requireNonNull(httpVersion), HttpResponseStatus.valueOf((int)muleResponse.getStatusCode(), (String)muleResponse.getReasonPhrase()));
        boolean hasTransferEncoding = false;
        boolean hasContentLength = false;
        MultiMap headers = muleResponse.getHeaders();
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString())) {
                hasContentLength = true;
                nettyResponse.headers().setInt((CharSequence)key, Integer.parseInt((String)headers.get((Object)key)));
            } else {
                nettyResponse.headers().set(key, MuleToNettyUtils.sanitizeValues(headers.getAll((Object)key)));
            }
            if (!key.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString())) continue;
            hasTransferEncoding = true;
        }
        if (hasContentLength || hasTransferEncoding) {
            return nettyResponse;
        }
        if (muleResponse.getEntity().getBytesLength().isPresent() && HttpVersion.HTTP_1_1.equals((Object)httpVersion)) {
            nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)muleResponse.getEntity().getBytesLength().getAsLong());
        }
        return nettyResponse;
    }

    public static HttpVersion toNettyHttpVersion(HttpProtocol protocol) {
        switch (protocol) {
            case HTTP_0_9: {
                return new HttpVersion("HTTP/0.9", false);
            }
            case HTTP_1_0: {
                return HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return HttpVersion.HTTP_1_1;
            }
        }
        return null;
    }

    public static void addAllRequestHeaders(HttpRequest request, HttpHeaders currentHeaders, URI uri) {
        currentHeaders.set("Host", (Object)MuleToNettyUtils.buildHostHeaderValue(uri));
        currentHeaders.set("User-Agent", (Object)"Mule HTTP Client");
        boolean hasTransferEncoding = false;
        Collection headerNames = request.getHeaderNames();
        for (String key : headerNames) {
            Collection<String> values = MuleToNettyUtils.sanitizeValues(request.getHeaderValues(key));
            currentHeaders.set(key, values);
            if (!key.equalsIgnoreCase("Transfer-Encoding")) continue;
            hasTransferEncoding = true;
        }
        if (!(hasTransferEncoding || !request.getProtocol().equals((Object)HttpProtocol.HTTP_1_1) || request.getEntity() instanceof EmptyHttpEntity && DEFAULT_EMPTY_BODY_METHODS.contains(request.getMethod()))) {
            OptionalLong bytesLength = request.getEntity().getBytesLength();
            if (bytesLength.isPresent()) {
                currentHeaders.setInt((CharSequence)"Content-Length", (int)bytesLength.getAsLong());
            } else {
                currentHeaders.set("Transfer-Encoding", (Object)HttpHeaderValues.CHUNKED);
            }
        }
    }

    public static Collection<String> sanitizeValues(Collection<String> values) {
        boolean hasToSanitize = false;
        for (String value : values) {
            if (value == null || !value.contains("\n")) continue;
            hasToSanitize = true;
            break;
        }
        if (!hasToSanitize) {
            return values;
        }
        ArrayList<String> sanitized = new ArrayList<String>(values.size());
        for (String value : values) {
            sanitized.add(MuleToNettyUtils.sanitizeValue(value));
        }
        return sanitized;
    }

    public static String sanitizeValue(String value) {
        if (value != null) {
            return value.replace('\n', ' ');
        }
        return null;
    }

    public static boolean calculateShouldRemoveContentLength(HttpRequest request) {
        return DEFAULT_EMPTY_BODY_METHODS.contains(request.getMethod()) && request.getEntity() instanceof EmptyHttpEntity;
    }

    private static int getDefaultPort(String scheme) {
        if (scheme == null || scheme.equals("http")) {
            return 80;
        }
        if (scheme.equals("https")) {
            return 443;
        }
        return -1;
    }

    private static String buildHostHeaderValue(URI uri) {
        int defaultPortForScheme = MuleToNettyUtils.getDefaultPort(uri.getScheme());
        Object specifiedHost = defaultPortForScheme == uri.getPort() ? uri.getHost() : uri.getHost() + ":" + uri.getPort();
        if (specifiedHost == null) {
            return "127.0.0.1";
        }
        return specifiedHost;
    }
}

