/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistry;

public class DefaultRequestMatcherRegistryBuilder<T>
implements RequestMatcherRegistry.RequestMatcherRegistryBuilder<T> {
    private Supplier<T> onMethodMismatch = DefaultRequestMatcherRegistry.NULL_SUPPLIER;
    private Supplier<T> onNotFound = DefaultRequestMatcherRegistry.NULL_SUPPLIER;
    private Supplier<T> onDisabled = DefaultRequestMatcherRegistry.NULL_SUPPLIER;
    private Supplier<T> onInvalidRequest = DefaultRequestMatcherRegistry.NULL_SUPPLIER;

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder<T> onMethodMismatch(Supplier<T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "A method mismatch item supplier must be specified.");
        this.onMethodMismatch = itemSupplier;
        return this;
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder<T> onNotFound(Supplier<T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "A not found item supplier must be specified.");
        this.onNotFound = itemSupplier;
        return this;
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder<T> onInvalidRequest(Supplier<T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "An invalid item supplier must be specified.");
        this.onInvalidRequest = itemSupplier;
        return this;
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder<T> onDisabled(Supplier<T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "A disabled item supplier must be specified.");
        this.onDisabled = itemSupplier;
        return this;
    }

    public RequestMatcherRegistry<T> build() {
        return new DefaultRequestMatcherRegistry<T>(this.onMethodMismatch, this.onNotFound, this.onInvalidRequest, this.onDisabled);
    }
}

