/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.BaseHttp2Response;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.NoOpResponseStatusCallback;
import org.mule.service.http.netty.utils.TcpTextClient;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-17408113")
public class HalfTcpShutdownTestCase
extends AbstractMuleTestCase {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private HttpServer httpServer;

    @Before
    public void setup() throws Exception {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        this.httpServer = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, true, 30000, 10000L, null, 300)).build();
        this.httpServer.start();
        this.httpServer.addRequestHandler("/test", (requestContext, responseCallback) -> executorService.submit(() -> {
            String asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent());
            responseCallback.responseReady((HttpResponse)new BaseHttp2Response(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }));
    }

    @After
    public void tearDown() {
        if (!this.httpServer.isStopped()) {
            this.httpServer.stop();
        }
        this.httpServer.dispose();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        executorService.shutdownNow();
    }

    @Test
    public void halfShutdownClient() throws IOException, InterruptedException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.serverPort.getNumber());){
            tcpTextClient.sendString("POST /test HTTP/1.1\nHost: localhost:" + this.serverPort.getNumber() + "\nTransfer-Encoding: chunked\n\n2\nOK\n0\n\n");
            tcpTextClient.shutdownWrite();
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.containsString((String)"content-length: 2"));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(2), (Matcher)Matchers.containsString((String)"OK"));
        }
    }
}

