/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.proxy.BlindTunnelingProxyClientHandler;
import org.mule.service.http.netty.impl.client.proxy.MessageForwardingProxyClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPipelineConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyPipelineConfigurer.class);
    private final ProxyConfig proxyConfig;

    public ProxyPipelineConfigurer(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void configurePipeline(ChannelPipeline pipeline, SocketAddress remoteAddress, boolean useTunneling) {
        if (this.proxyConfig == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No proxy configured for channel {}", (Object)pipeline.channel().id().asLongText());
            }
            return;
        }
        if (this.isNonProxyHost(this.proxyConfig.getNonProxyHosts(), remoteAddress)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Proxy skipped in channel {} because nonProxyHost matches address {}", (Object)pipeline.channel().id().asLongText(), (Object)remoteAddress);
            }
            return;
        }
        if (useTunneling) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Establish a blind forwarding proxy tunnel (with CONNECT method) for channel {}", (Object)pipeline.channel().id().asLongText());
            }
            pipeline.addFirst("TunnelProxyHandler", (ChannelHandler)new BlindTunnelingProxyClientHandler(this.proxyConfig));
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Establish a message-forwarding proxy (without CONNECT method) for channel {}", (Object)pipeline.channel().id().asLongText());
        }
        pipeline.addAfter("reactor.left.httpCodec", "ProxyAuthHandler", (ChannelHandler)new MessageForwardingProxyClientHandler(this.proxyConfig));
    }

    private boolean isNonProxyHost(String nonProxyHosts, SocketAddress socketAddress) {
        if (nonProxyHosts == null || nonProxyHosts.isEmpty()) {
            return false;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        String hostString = ((InetSocketAddress)socketAddress).getHostString();
        for (String nonProxyHost : nonProxyHosts.split(",")) {
            if (!nonProxyHost.trim().equals(hostString)) continue;
            return true;
        }
        return false;
    }
}

