/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.auth.AuthHeaderFactory;
import org.mule.service.http.netty.impl.client.auth.BasicAuthHeaderFactory;
import org.mule.service.http.netty.impl.client.auth.ntlm.NtlmMessageFactory;

public class ProxyAuthenticator {
    private static final String AUTH_BASIC = "basic";
    private static final String AUTH_NONE = "none";
    private static final String AUTH_NTLM = "ntlm";
    private final String authScheme;
    private final AuthHeaderFactory authHeaderFactory;

    public ProxyAuthenticator(ProxyConfig proxyConfig) {
        if (proxyConfig.getUsername() == null) {
            this.authScheme = AUTH_NONE;
            this.authHeaderFactory = null;
            return;
        }
        if (proxyConfig instanceof ProxyConfig.NtlmProxyConfig) {
            ProxyConfig.NtlmProxyConfig ntlmProxyConfig = (ProxyConfig.NtlmProxyConfig)proxyConfig;
            this.authScheme = AUTH_NTLM;
            this.authHeaderFactory = new NtlmMessageFactory(ntlmProxyConfig.getNtlmDomain(), null, ntlmProxyConfig.getUsername(), ntlmProxyConfig.getPassword());
            return;
        }
        this.authScheme = AUTH_BASIC;
        this.authHeaderFactory = new BasicAuthHeaderFactory(true, proxyConfig.getUsername(), proxyConfig.getPassword());
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public boolean hasFinished() {
        if (this.authHeaderFactory == null) {
            return true;
        }
        return this.authHeaderFactory.hasFinished();
    }

    public String getNextHeader(String receivedAuthenticateHeader) throws Exception {
        if (this.authHeaderFactory == null) {
            return null;
        }
        return this.authHeaderFactory.getNextHeader(receivedAuthenticateHeader);
    }
}

