/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;

@Story(value="Streaming")
public class HttpClientKnownSizeTestCase
extends AbstractHttpClientTestCase {
    protected static final String PAYLOAD = "Lionel Andres Messi";
    private HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("known-size-test");

    public HttpClientKnownSizeTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase()).entity((HttpEntity)new ByteArrayHttpEntity(PAYLOAD.getBytes()))).build();
    }

    @Test
    public void withStreaming() throws Exception {
        this.testWithKnownLength(true);
    }

    @Test
    public void withoutStreaming() throws Exception {
        this.testWithKnownLength(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithKnownLength(boolean streaming) throws Exception {
        HttpClient client = this.service.getClientFactory().create(this.clientBuilder.setResponseBufferSize(DataUnit.KB.toBytes(10)).setStreaming(streaming).build());
        client.start();
        try {
            HttpResponse response = (HttpResponse)client.sendAsync(this.getRequest(), this.getDefaultOptions(3000)).get();
            long sizeAsLong = PAYLOAD.length();
            MatcherAssert.assertThat((Object)response.getEntity().getBytesLength().orElse(0L), (Matcher)Matchers.is((Object)sizeAsLong));
        }
        finally {
            client.stop();
        }
    }

    protected HttpRequest getRequest() {
        return HttpRequest.builder().uri(this.getUri()).build();
    }
}

