/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.streaming;

import java.io.OutputStream;

/**
 * Extends the {@link OutputStream} with a method {@link #cancel(Throwable)}, intended to mark the stream with a certain error
 * instead of just closing it.
 */
public abstract class CancelableOutputStream extends OutputStream {

  /**
   * Marks the stream with an error instead of just closing it.
   * 
   * @param error the error.
   */
  public abstract void cancel(Throwable error);
}
