/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.provider;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.netty.impl.provider.NettyHttpServiceProvider;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.service.http.test.common.AbstractHttpTestCase;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class NettyHttpServiceProviderTestCase extends AbstractHttpTestCase {

  private NettyHttpServiceProvider httpServiceProvider;

  @Before
  public void setup() {
    SchedulerService schedulerService = Mockito.mock(SchedulerService.class);
    httpServiceProvider = new NettyHttpServiceProvider();
    httpServiceProvider.setSchedulerService(schedulerService);
  }

  @Test
  public void providerCreatesDefinitionWithCorrectClass() {
    ServiceDefinition serviceDefinition = httpServiceProvider.getServiceDefinition();
    assertThat(serviceDefinition.getServiceClass(), is(HttpService.class));
  }

  @Test
  public void createdDefinitionReturnsCorrectServiceImplementation() {
    ServiceDefinition serviceDefinition = httpServiceProvider.getServiceDefinition();
    assertThat(serviceDefinition.getService(), is(instanceOf(NettyHttpServiceImplementation.class)));
    assertThat(serviceDefinition.getService().getName(), is("HTTP Service using Netty"));
  }
}
