/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client;

import static io.netty.handler.codec.http.HttpHeaderNames.CONNECTION;
import static io.netty.handler.codec.http.HttpHeaderValues.CLOSE;
import static io.netty.handler.codec.http.HttpHeaderValues.KEEP_ALIVE;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;

public class HttpClientHandler extends ChannelDuplexHandler {

  private final boolean usePersistentConnections;

  public HttpClientHandler(boolean usePersistentConnections) {
    this.usePersistentConnections = usePersistentConnections;
  }

  @Override
  public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
    // modify message on way out to add headers if needed
    if (msg instanceof HttpRequest) {
      final HttpRequest request = (HttpRequest) msg;

      if (!request.headers().contains(CONNECTION)) {
        // We don't use Netty's built-in setKeepAlive method because:
        // 1. Backwards compatibility with Grizzly implementation
        // 2. Several servers close the connection if we don't explicitly set keep-alive
        if (usePersistentConnections) {
          request.headers().set(CONNECTION, KEEP_ALIVE);
        } else {
          request.headers().set(CONNECTION, CLOSE);
        }
      }
    }

    super.write(ctx, msg, promise);
  }
}
