/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.service.ContextHttpServerFactory;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;

@Feature(value="Resources isolation between applications/contexts")
@Story(value="Server isolation between applications/contexts")
@Issue(value="W-19160161")
public class ServerFactoryIsolationTestCase
extends AbstractHttpServiceTestCase {
    private static final HttpServerConfiguration SERVER_CONFIGURATION = new HttpServerConfiguration.Builder().setName("CONFIG_NAME").setHost("localhost").setPort(8081).build();
    private static final String MULE_CONTEXT_ID = "muleContextId";

    public ServerFactoryIsolationTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Test
    public void unknownArtifactTypeFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.PLUGIN);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void appWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.APP);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void domainWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.DOMAIN);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void policyWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.POLICY);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void sameAppAccessSameServer() throws Exception {
        String app = "app";
        HttpServerFactory factory = this.newAppServerFactory("app", Optional.empty());
        MatcherAssert.assertThat((Object)factory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(SERVER_CONFIGURATION.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void sameDomainAccessSameServer() throws Exception {
        String domain = "domain";
        HttpServerFactory factory = this.newDomainServerFactory("domain");
        MatcherAssert.assertThat((Object)factory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(SERVER_CONFIGURATION.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void samePolicyAccessSameServer() throws Exception {
        String policy = "policy";
        HttpServerFactory factory = this.newPolicyServerFactory("policy");
        MatcherAssert.assertThat((Object)factory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(SERVER_CONFIGURATION.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void appsAccessServerFromDomain() throws Exception {
        String app1 = "app1";
        String app2 = "app2";
        String domain = "domain";
        HttpServerFactory appFactory1 = this.newAppServerFactory("app1", Optional.of("domain"));
        HttpServerFactory appFactory2 = this.newAppServerFactory("app2", Optional.of("domain"));
        HttpServerFactory domainFactory = this.newDomainServerFactory("domain");
        MatcherAssert.assertThat((Object)domainFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)appFactory1.lookup(SERVER_CONFIGURATION.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)appFactory2.lookup(SERVER_CONFIGURATION.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void policyCantAccessAppServer() throws Exception {
        String policy = "policy";
        String app = "app";
        HttpServerFactory appFactory = this.newAppServerFactory("app", Optional.empty());
        HttpServerFactory policyFactory = this.newPolicyServerFactory("policy");
        MatcherAssert.assertThat((Object)appFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThrows(ServerNotFoundException.class, () -> policyFactory.lookup(SERVER_CONFIGURATION.getName()));
    }

    @Test
    public void policyCantAccessAppServerWithSameNames() throws Exception {
        String name = "sameName";
        HttpServerFactory appFactory = this.newAppServerFactory("sameName", Optional.empty());
        HttpServerFactory policyFactory = this.newPolicyServerFactory("sameName");
        MatcherAssert.assertThat((Object)appFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThrows(ServerNotFoundException.class, () -> policyFactory.lookup(SERVER_CONFIGURATION.getName()));
    }

    @Test
    public void appCantAccessDomainServerWithSameNames() throws Exception {
        String name = "sameName";
        HttpServerFactory appFactory = this.newAppServerFactory("sameName", Optional.empty());
        HttpServerFactory domainFactory = this.newDomainServerFactory("sameName");
        MatcherAssert.assertThat((Object)domainFactory.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThrows(ServerNotFoundException.class, () -> appFactory.lookup(SERVER_CONFIGURATION.getName()));
    }

    @Test
    public void differentAppsDontAccessSameServers() throws Exception {
        String app1 = "app1";
        String app2 = "app2";
        HttpServerFactory factory1 = this.newAppServerFactory("app1", Optional.empty());
        HttpServerFactory factory2 = this.newAppServerFactory("app2", Optional.empty());
        MatcherAssert.assertThat((Object)factory1.create(SERVER_CONFIGURATION), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThrows(ServerNotFoundException.class, () -> factory2.lookup(SERVER_CONFIGURATION.getName()));
    }

    private HttpServerFactory newAppServerFactory(String appName, Optional<String> domainName) {
        return this.newServerFactory(Optional.of(appName), domainName, ArtifactType.APP);
    }

    private HttpServerFactory newDomainServerFactory(String domainName) {
        return this.newServerFactory(Optional.empty(), Optional.of(domainName), ArtifactType.DOMAIN);
    }

    private HttpServerFactory newPolicyServerFactory(String policyName) {
        return this.newServerFactory(Optional.of(policyName), Optional.empty(), ArtifactType.POLICY);
    }

    protected HttpServerFactory newServerFactory(Optional<String> artifactName, Optional<String> domainName, ArtifactType artifactType) {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)20L);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getArtifactType()).thenReturn((Object)artifactType);
        Mockito.when((Object)muleContext.getId()).thenReturn((Object)MULE_CONTEXT_ID);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByName("app.name")).thenReturn(artifactName);
        Mockito.when((Object)registry.lookupByName("domain.name")).thenReturn(domainName);
        return ((NettyHttpServiceImplementation)this.service).getServerFactory(muleContext, registry);
    }

    protected void assertServerFactory(HttpServerFactory serverFactory, String contextName, Optional<String> parentContext) {
        MatcherAssert.assertThat((Object)((ContextHttpServerFactory)serverFactory).getContextName(), (Matcher)Matchers.is((Object)contextName));
        MatcherAssert.assertThat((Object)((ContextHttpServerFactory)serverFactory).getParentContextName(), (Matcher)Matchers.is((Object)parentContext.orElse(null)));
    }
}

