/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.mule.service.http.netty.impl.streaming.StreamingEntitySender;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;

public class SendNextChunkListener implements ChannelFutureListener {

  private final StreamingEntitySender streamingEntitySender;
  private final StatusCallback statusCallback;

  public SendNextChunkListener(StreamingEntitySender streamingEntitySender, StatusCallback statusCallback) {
    this.streamingEntitySender = streamingEntitySender;
    this.statusCallback = statusCallback;
  }

  @Override
  public void operationComplete(ChannelFuture channelFuture) throws Exception {
    if (channelFuture.isSuccess()) {
      streamingEntitySender.sendNextChunk();
    } else {
      statusCallback.onFailure(channelFuture.cause());
    }
  }
}
