/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.av;

/**
 * Represents the AV_PAIR structure for channel bindings in NTLM authentication. This class extends {@code AvPair} to specifically
 * handle the channel binding hash, which is used to bind the client and server to a specific communication channel in NTLM.
 *
 * <p>
 * This implementation is based on the jcifs library, available at:
 * <a href="https://github.com/codelibs/jcifs">https://github.com/codelibs/jcifs</a>
 * </p>
 *
 * @see <a href="https://github.com/codelibs/jcifs">jcifs on GitHub</a>
 */
public class AvChannelBindings extends AvPair {

  /**
   * Constructs an instance of {@code AvChannelBindings} with the specified channel binding hash.
   *
   * @param channelBindingHash the hash value of the channel bindings to be used in NTLM authentication.
   */
  public AvChannelBindings(byte[] channelBindingHash) {
    super(MsvAvChannelBindings, channelBindingHash);
  }
}
