/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client;

import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

/**
 * Creates {@link HttpClient} from the {@link HttpClientConfiguration} and some additional contextual information.
 */
public interface ContextHttpClientConnectionFactory {

  /**
   * Creates a {@link HttpClient}.
   * 
   * @param configuration the configuration of the new client.
   * @return the new client.
   */
  HttpClient create(HttpClientConfiguration configuration);
}
