/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.service.http.netty.impl.server.util.DecodingException;

public class HttpParser {
    private static final Pattern SPACE_ENTITY_OR_PLUS_SIGN_REGEX = Pattern.compile("%20|\\+");
    private static final String NAME_ATTRIBUTE = "name";

    public static String extractPath(String uri) {
        String path = uri;
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String decodePath(String path) throws DecodingException {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new DecodingException(String.format("Unable to decode malformed url %s", path), e);
        }
    }

    public static byte[] multipartToBytes(MultipartHttpEntity entity, final MediaType mediaType, String boundary, Map<String, String> additionalPartHeaders) throws IOException {
        try {
            final ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
            for (HttpPart httpPart : entity.getParts()) {
                String subType = mediaType.getSubType();
                bodyParts.add(HttpParser.httpPartToBodyPart(httpPart, "mixed".equals(subType) ? "attachment" : subType, additionalPartHeaders));
            }
            MimeMultipart mimeMultipart = new MimeMultipart((DataSource)new MultipartDataSource(){

                public InputStream getInputStream() throws IOException {
                    throw new UnsupportedOperationException();
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException();
                }

                public String getContentType() {
                    return mediaType.toRfcString();
                }

                public String getName() {
                    throw new UnsupportedOperationException();
                }

                public int getCount() {
                    return bodyParts.size();
                }

                public BodyPart getBodyPart(int index) throws MessagingException {
                    return (BodyPart)bodyParts.get(index);
                }
            });
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mimeMultipart.writeTo((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (MessagingException e) {
            throw new IOException("Error processing multipart content", e);
        }
    }

    private static BodyPart httpPartToBodyPart(HttpPart httpPart, String subType, Map<String, String> additionalPartHeaders) throws MessagingException, IOException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        byte[] contentBytes = IOUtils.toByteArray((InputStream)httpPart.getInputStream());
        bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentBytes, httpPart.getContentType())));
        Collection headerNames = httpPart.getHeaderNames();
        boolean contentTypeHeaderPresent = false;
        boolean contentDispositionHeaderPresent = false;
        for (String string : headerNames) {
            if (string.equalsIgnoreCase("Content-Type")) {
                contentTypeHeaderPresent = true;
            }
            if (string.equalsIgnoreCase("Content-Disposition")) {
                contentDispositionHeaderPresent = true;
            }
            for (String headerValue : httpPart.getHeaders(string)) {
                bodyPart.addHeader(string, headerValue);
            }
        }
        if (!contentTypeHeaderPresent) {
            bodyPart.addHeader("Content-Type", httpPart.getContentType());
        }
        if (!contentDispositionHeaderPresent && httpPart.getName() != null) {
            bodyPart.addHeader("Content-Disposition", subType + "; name=\"" + httpPart.getName() + "\"");
        }
        for (Map.Entry entry : additionalPartHeaders.entrySet()) {
            if (headerNames.contains(entry.getKey())) continue;
            bodyPart.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return bodyPart;
    }

    public static ByteArrayHttpEntity fromMultipartEntity(String contentType, MultipartHttpEntity entity, Consumer<String> contentTypeConsumer, Map<String, String> additionalPartHeaders) throws IOException {
        MediaType mediaType;
        String boundary;
        if (contentType == null) {
            boundary = HttpParser.generateBoundary();
            mediaType = MediaType.MULTIPART_FORM_DATA.withParamaters(Collections.singletonMap("boundary", boundary));
            contentTypeConsumer.accept(mediaType.toRfcString());
        } else {
            mediaType = MediaType.parse((String)contentType);
            boundary = mediaType.getParameter("boundary");
            if (boundary == null) {
                boundary = HttpParser.generateBoundary();
                mediaType = mediaType.withParamaters(Collections.singletonMap("boundary", boundary));
                contentTypeConsumer.accept(mediaType.toRfcString());
            }
        }
        return new ByteArrayHttpEntity(HttpParser.multipartToBytes(entity, mediaType, boundary, additionalPartHeaders));
    }

    private static String generateBoundary() {
        return "----MuleMultipart" + UUID.randomUUID().toString().replace("-", "");
    }

    public static Collection<HttpPart> parseMultipartContent(InputStream content, String contentType) throws IOException {
        MimeMultipart mimeMultipart = null;
        ArrayList parts = Lists.newArrayList();
        try {
            mimeMultipart = new MimeMultipart((DataSource)new ByteArrayDataSource(content, contentType));
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        try {
            int partCount = mimeMultipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                String[] contentIdHeader;
                String contentDisposition;
                String filename;
                BodyPart part = mimeMultipart.getBodyPart(i);
                String partName = filename = part.getFileName();
                String[] contentDispositions = part.getHeader("Content-Disposition");
                if (contentDispositions != null && (contentDisposition = contentDispositions[0]).contains(NAME_ATTRIBUTE)) {
                    partName = contentDisposition.substring(contentDisposition.indexOf(NAME_ATTRIBUTE) + NAME_ATTRIBUTE.length() + 2);
                    partName = partName.substring(0, partName.indexOf("\""));
                }
                if (partName == null && mimeMultipart.getContentType().contains(MediaType.MULTIPART_RELATED.toString()) && (contentIdHeader = part.getHeader("Content-Id")) != null && contentIdHeader.length > 0) {
                    partName = contentIdHeader[0];
                }
                HttpPart httpPart = new HttpPart(partName, filename, IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), part.getSize());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    httpPart.addHeader(header.getName(), header.getValue());
                }
                parts.add(httpPart);
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        return parts;
    }

    public static String normalizePathWithSpacesOrEncodedSpaces(String path) {
        return SPACE_ENTITY_OR_PLUS_SIGN_REGEX.matcher(path).replaceAll(" ");
    }
}

