/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.netty.impl.server.FinishStreamingListener;
import org.mule.service.http.netty.impl.server.ResponseSender;
import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public abstract class BaseResponseSender
implements ResponseSender {
    protected final HttpRequest request;
    protected final org.mule.runtime.http.api.domain.message.response.HttpResponse response;
    private final ChannelHandlerContext ctx;
    private final StatusCallback statusCallback;
    private HttpResponse savedHeader;

    protected BaseResponseSender(HttpRequest request, ChannelHandlerContext ctx, org.mule.runtime.http.api.domain.message.response.HttpResponse response, StatusCallback statusCallback) {
        Preconditions.checkArgument((statusCallback != null ? 1 : 0) != 0, (String)"statusCallback can't be null");
        this.request = request;
        this.response = response;
        this.ctx = ctx;
        this.statusCallback = statusCallback;
        this.savedHeader = null;
    }

    @Override
    public void send() throws IOException {
        this.saveHeader(this.getNettyResponseHeader());
        this.sendContent();
    }

    private void saveHeader(HttpResponse nettyResponse) {
        this.savedHeader = nettyResponse;
    }

    protected void sendHeaderIfNeeded() {
        if (this.savedHeader != null) {
            this.ctx.write((Object)this.savedHeader);
            this.savedHeader = null;
        }
    }

    private HttpResponse getNettyResponseHeader() {
        HttpProtocol httpProtocol = this.request.getProtocol();
        return MuleToNettyUtils.adaptResponseWithoutBody(this.response, httpProtocol);
    }

    protected ChannelPromise finishStreamingPromise(InputStream stream) {
        return this.createPromise(new FinishStreamingListener(stream, this.statusCallback));
    }

    protected ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    protected void sendLastContentAndFinishStreaming(ByteBuf content, InputStream contentAsInputStream) {
        this.sendHeaderIfNeeded();
        this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(content), this.finishStreamingPromise(contentAsInputStream));
    }

    protected ChannelPromise createPromise(ChannelFutureListener futureListener) {
        ChannelPromise channelPromise = this.ctx.newPromise();
        channelPromise.addListener((GenericFutureListener)futureListener);
        return channelPromise;
    }

    protected abstract void sendContent() throws IOException;
}

