/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.TcpTextClient;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-17413024")
public class ServerReadTimeoutTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private static final long SMALL_READ_TIMEOUT_MILLIS = 100L;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private HttpServer httpServer;

    @Before
    public void setup() throws Exception {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        this.httpServer = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, "test-server", true, 30000, 100L, null, 300, (ExecutorService)executorRule.getExecutor())).build();
        this.httpServer.start();
        this.httpServer.addRequestHandler("/test", (requestContext, responseCallback) -> executorRule.getExecutor().submit(() -> {
            String asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent());
            responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }));
    }

    @After
    public void tearDown() {
        if (!this.httpServer.isStopped()) {
            this.httpServer.stop();
        }
        this.httpServer.dispose();
    }

    @Test
    public void sendPartialRequestShouldTimeout() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.serverPort.getNumber());){
            tcpTextClient.sendString("POST /test HTTP/1.1\r\nHost: localhost: %d\r\nTransfer-Encoding: chunked\r\n\r\n7\r\nPartial\r\n".formatted(this.serverPort.getNumber()));
            String header = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)header, (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 408 Request Timeout\r\nConnection: close\r\nContent-Length: 23"));
            String content = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"Timeout reading request"));
            String nothing = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)nothing, (Matcher)Matchers.is((Object)""));
        }
    }
}

