/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-15631414")
public class NoContentTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private HttpClient client;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(this.serverPort.getNumber());

    @Before
    public void setUp() {
        this.client = NettyHttpClient.builder().withIOTasksScheduler(executorRule.getExecutor()).build();
        this.client.start();
        this.server.setResponse("HTTP/1.1 204 No Content\r\n\r\nGarbage");
    }

    @Test
    public void responseWithEmptyContentFor204StatusCode() throws IOException, ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder((boolean)HttpServerProperties.PRESERVE_HEADER_CASE).uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NO_CONTENT.getStatusCode()));
        MatcherAssert.assertThat((Object)response.getReasonPhrase(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NO_CONTENT.getReasonPhrase()));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
    }
}

