/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;

@Story(value="Max Connections")
public class HttpClientMaxConnectionsTestCase
extends AbstractHttpClientTestCase {
    private static final String ERROR_MESSAGE = "Connection limit exceeded, cannot process request";
    private Latch handling = new Latch();
    private Latch complete = new Latch();
    private HttpClient client;

    public HttpClientMaxConnectionsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws CreateException {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setMaxConnections(1).setName("max-connections-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        this.handling.release();
        try {
            this.complete.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return HttpResponse.builder().build();
    }

    @Test
    public void failsOnConnectionsExceededWhenSync() throws Exception {
        try {
            this.client.sendAsync(this.getRequest());
            this.handling.await();
            IOException error = (IOException)Assert.assertThrows(IOException.class, () -> this.client.send(this.getRequest(), HttpRequestOptions.builder().responseTimeout(1).build()));
            MatcherAssert.assertThat((Object)error, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)ERROR_MESSAGE))));
        }
        finally {
            this.complete.release();
        }
    }

    @Test
    public void failsOnConnectionsExceededWhenAsync() throws Exception {
        try {
            this.client.sendAsync(this.getRequest());
            this.handling.await();
            CompletableFuture future = this.client.sendAsync(this.getRequest(), HttpRequestOptions.builder().responseTimeout(1).build());
            ExecutionException error = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
            MatcherAssert.assertThat((Object)error, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(IOException.class)));
            MatcherAssert.assertThat((Object)error, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)ERROR_MESSAGE))));
        }
        finally {
            this.complete.release();
        }
    }

    private HttpRequest getRequest() {
        return HttpRequest.builder().uri(this.getUri()).build();
    }
}

