/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.server.sse;

import java.util.function.Consumer;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.service.http.common.server.sse.SseRequestContextImpl;
import org.mule.service.http.common.server.sse.SseResponseStarter;

public class SseRequestHandler
implements RequestHandler {
    private final Consumer<SseRequestContext> onRequest;
    private final Consumer<SseClient> onSseClient;

    public SseRequestHandler(Consumer<SseRequestContext> onRequest, Consumer<SseClient> onSseClient) {
        this.onRequest = onRequest;
        this.onSseClient = onSseClient;
    }

    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        SseRequestContextImpl context = new SseRequestContextImpl(requestContext, responseCallback);
        this.onRequest.accept(context);
        if (context.isResponded()) {
            return;
        }
        SseClientConfig clientConfig = SseClientConfig.builderFrom((HttpRequestContext)requestContext).withClientId((String)context.getClientId().orElse(null)).customizeResponse(context.getResponseCustomizer()).build();
        SseClient sseClient = new SseResponseStarter().startResponse(clientConfig, responseCallback);
        this.onSseClient.accept(sseClient);
    }
}

