/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.rules.ExternalResource;

public class HardcodedResponseTcpServer
extends ExternalResource {
    private final int port;
    private AcceptorThread acceptorThread;
    private String response = "HTTP/1.1 200 OK\ncontent-length: 0\n\n";
    private final AtomicInteger acceptedCount = new AtomicInteger(0);
    private final List<RequestHandlerThread> requestHandlerThreads = new ArrayList<RequestHandlerThread>();
    private final ConcurrentLinkedQueue<StringBuilder> receivedRawRequests = new ConcurrentLinkedQueue();
    private boolean isCloseOutputAfterResponse = false;

    public HardcodedResponseTcpServer(int port) {
        this.port = port;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void setCloseOutputAfterResponse(boolean closeOutputAfterResponse) {
        this.isCloseOutputAfterResponse = closeOutputAfterResponse;
    }

    protected void before() throws Throwable {
        ServerSocket serverSocket = new ServerSocket(this.port);
        this.acceptorThread = new AcceptorThread(serverSocket, this::onAccepted);
        this.acceptorThread.start();
    }

    private void onAccepted(Socket socket) {
        this.acceptedCount.incrementAndGet();
        RequestHandlerThread handlerThread = new RequestHandlerThread(socket, this.response, this.acceptedCount::decrementAndGet, this.receivedRawRequests, this.isCloseOutputAfterResponse);
        handlerThread.start();
        this.requestHandlerThreads.add(handlerThread);
    }

    public int acceptedCount() {
        return this.acceptedCount.get();
    }

    public List<String> getReceivedRawRequests() {
        return this.receivedRawRequests.stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    protected void after() {
        try {
            this.acceptorThread.close();
            this.acceptorThread.join();
            for (RequestHandlerThread requestHandlerThread : this.requestHandlerThreads) {
                requestHandlerThread.close();
                requestHandlerThread.join();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AcceptorThread
    extends Thread {
        private final ServerSocket serverSocket;
        private final Consumer<Socket> onAccept;
        private boolean isClosed;

        public AcceptorThread(ServerSocket serverSocket, Consumer<Socket> onAccept) {
            this.serverSocket = serverSocket;
            this.onAccept = onAccept;
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (!this.isClosed) {
                        Socket accepted = this.serverSocket.accept();
                        this.onAccept.accept(accepted);
                    }
                }
                catch (IOException e) {
                    if (this.isClosed) break block3;
                    throw new RuntimeException(e);
                }
            }
        }

        public void close() throws IOException {
            this.isClosed = true;
            this.serverSocket.close();
        }
    }

    private static class RequestHandlerThread
    extends Thread {
        private final Socket socket;
        private final String response;
        private final Runnable onClosed;
        private final StringBuilder receivedRawRequest;
        private final boolean isCloseOutputAfterResponse;

        private RequestHandlerThread(Socket socket, String response, Runnable onClosed, ConcurrentLinkedQueue<StringBuilder> receivedRawRequests, boolean isCloseOutputAfterResponse) {
            this.socket = socket;
            this.response = response;
            this.onClosed = onClosed;
            this.isCloseOutputAfterResponse = isCloseOutputAfterResponse;
            this.receivedRawRequest = new StringBuilder();
            receivedRawRequests.add(this.receivedRawRequest);
        }

        @Override
        public void run() {
            boolean responseIsSent = false;
            try {
                InputStream stream = this.socket.getInputStream();
                int ret = 0;
                while (ret != -1) {
                    byte[] buf = new byte[2048];
                    ret = stream.read(buf);
                    if (ret == -1) continue;
                    this.receivedRawRequest.append(new String(buf));
                    this.socket.getOutputStream().write(this.response.getBytes());
                    this.socket.getOutputStream().flush();
                    if (this.isCloseOutputAfterResponse) {
                        this.socket.getOutputStream().close();
                    }
                    responseIsSent = true;
                }
            }
            catch (SocketException e) {
                if (!responseIsSent) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.onClosed.run();
            }
        }

        public void close() throws IOException {
            this.socket.close();
        }
    }
}

