/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.util;

import io.qameta.allure.Issue;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.service.http.netty.impl.util.HttpUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class HttpUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-16010240")
    public void tryGeneratingUriStringWithoutSchemeFails() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpUtils.buildUriString((URI)URI.create("localhost"), (MultiMap)MultiMap.emptyMultiMap()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"The uri provided 'localhost' must contain a scheme."));
    }

    @Test
    @Issue(value="W-16010240")
    public void tryGeneratingUriStringWithoutHostFails() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpUtils.buildUriString((URI)URI.create("http:/"), (MultiMap)MultiMap.emptyMultiMap()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"The uri provided 'http:/' must contain a host."));
    }

    @Test
    public void generateUriStringWithExistingAndExtraQueryParams() {
        MultiMap params = new MultiMap();
        params.put((Object)"other", (Object)"value");
        URI uri = URI.create("http://localhost:8080/myresource?qpname=qpvalue");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/myresource?qpname=qpvalue&other=value"));
    }

    @Test
    public void generateUriStringWithEmptyQueryParams() {
        URI uri = URI.create("http://localhost:8080/myresource?qpname=qpvalue");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)MultiMap.emptyMultiMap());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/myresource?qpname=qpvalue"));
    }

    @Test
    public void generateUriStringWithNullQueryParams() {
        URI uri = URI.create("http://localhost:8080/myresource?qpname=qpvalue");
        String result = HttpUtils.buildUriString((URI)uri, null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/myresource?qpname=qpvalue"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testUrlWithPathAndQuery() {
        MultiMap params = new MultiMap();
        params.put((Object)"other", (Object)"value");
        URI uri = URI.create("http://localhost:8080/test?q=1");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/test?q=1&other=value"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testUrlFragmentWithTrickAuthority() {
        URI uri = URI.create("http://1.2.3.4:81#@5.6.7.8:82/aaa/b?q=xxx");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)MultiMap.emptyMultiMap());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://1.2.3.4:81#@5.6.7.8:82/aaa/b?q=xxx"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testRootWithQueryParameters() {
        URI uri = URI.create("http://localhost:8080/");
        MultiMap params = new MultiMap();
        params.put((Object)"newParam", (Object)"newValue");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/?newParam=newValue"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testRelativeUrlWithQuery() {
        URI uri = URI.create("http://localhost:8080/test");
        MultiMap params = new MultiMap();
        params.put((Object)"q", (Object)"2");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/test?q=2"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testUrlWithEmptyAnchor() {
        URI uri = URI.create("http://localhost:8080/resource#");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)MultiMap.emptyMultiMap());
        MatcherAssert.assertThat((Object)uri.getFragment(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/resource#"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testAnchorWithOneSpecialCharacterAndQueryParameter() {
        URI uri = URI.create("http://localhost:8080/resource#section?param=value&otherParam=otherValue");
        MultiMap params = new MultiMap();
        params.put((Object)"myParam", (Object)"myValue");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)uri.getFragment(), (Matcher)Matchers.is((Object)"section?param=value&otherParam=otherValue"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/resource#section?param=value&otherParam=otherValue&myParam=myValue"));
    }

    @Test
    @Issue(value="W-15631603")
    public void testAnchorWithMultipleSpecialCharactersAndMultipleQueryParameters() {
        URI uri = URI.create("http://localhost:8080/resource?queryParam=value#section?param1=value1&param2=value2&param3=value3");
        MultiMap params = new MultiMap();
        params.put((Object)"myParam-1", (Object)"myValue-1");
        params.put((Object)"myParam-2", (Object)"myValue-2");
        String result = HttpUtils.buildUriString((URI)uri, (MultiMap)params);
        MatcherAssert.assertThat((Object)uri.getFragment(), (Matcher)Matchers.is((Object)"section?param1=value1&param2=value2&param3=value3"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"http://localhost:8080/resource?queryParam=value%23section&myParam-1=myValue-1&myParam-2=myValue-2"));
    }
}

