/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import java.util.Collections;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.service.http.test.util.ClassUtils;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractHttpServiceTestCase
extends AbstractMuleTestCase {
    public String serviceToLoad;
    protected HttpService service;
    private SchedulerService schedulerService;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        if (ParameterContext.isParameterSet()) {
            return Collections.singletonList((Object[])ParameterContext.getParameter(Object[].class));
        }
        return Collections.singletonList(new String[]{NettyHttpServiceImplementation.class.getName()});
    }

    public AbstractHttpServiceTestCase(String serviceToLoad) {
        this.serviceToLoad = serviceToLoad;
    }

    @Before
    public void createServices() throws Exception {
        this.schedulerService = this.getSchedulerService();
        this.service = (HttpService)ClassUtils.instantiateClass(this.serviceToLoad, new Object[]{this.schedulerService}, ((Object)((Object)this)).getClass().getClassLoader());
        LifecycleUtils.startIfNeeded((Object)this.service);
    }

    protected SchedulerService getSchedulerService() {
        return new SimpleUnitTestSupportSchedulerService();
    }

    @After
    public void closeServices() throws Exception {
        if (this.service != null) {
            LifecycleUtils.stopIfNeeded((Object)this.service);
        }
        LifecycleUtils.stopIfNeeded((Object)this.schedulerService);
    }

    public static class IgnoreResponseStatusCallback
    implements ResponseStatusCallback {
        public void responseSendFailure(Throwable throwable) {
            TestCase.fail((String)throwable.getMessage());
        }

        public void responseSendSuccessfully() {
        }
    }
}

