/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.message.BaseHttp2Request;
import org.mule.service.http.netty.impl.message.Http2FramesHandlerAdapter;
import org.mule.service.http.netty.impl.message.content.BaseHttpEntity;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

public class NettyToMuleHttp2RequestHandlerAdapter
extends Http2FramesHandlerAdapter {
    private final HttpListenerRegistry httpListenerRegistry;
    private final BaseHttpEntity requestContent;

    public NettyToMuleHttp2RequestHandlerAdapter(HttpListenerRegistry httpListenerRegistry) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.requestContent = new BaseHttpEntity();
    }

    @Override
    public void onHeadersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws IOException, InterruptedException {
        if (headersFrame.isEndStream()) {
            this.requestContent.close();
        }
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        DefaultServerAddress serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
        BaseHttp2Request request = new BaseHttp2Request(headersFrame.headers().method().toString(), headersFrame.headers().path().toString(), this.requestContent);
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler(serverAddress, request);
        requestHandler.handleRequest((HttpRequestContext)new NettyHttpRequestContext(request, ctx, null), (HttpResponseReadyCallback)new NettyHttp2RequestReadyCallback(ctx, headersFrame));
    }

    @Override
    public void onDataFrameRead(ChannelHandlerContext ctx, Http2DataFrame dataFrame) throws IOException {
        ByteBuf content = dataFrame.content();
        byte[] data = ByteBufUtil.getBytes((ByteBuf)content);
        this.requestContent.feed(data, 0, data.length);
        if (dataFrame.isEndStream()) {
            this.requestContent.close();
        }
    }
}

