/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.WebSocketsHandlersRegistry;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyHttpServer
implements HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHttpServer.class);
    private static final int DEFAULT_SELECTORS_COUNT = Math.min(Runtime.getRuntime().availableProcessors(), 2);
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private static final int STOPPING = 3;
    private int status = 0;
    private SslContext sslContext;
    private EventLoopGroup acceptorGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;
    private ServerAddress serverAddress;
    private Runnable onDisposeCallback;
    private AcceptedConnectionChannelInitializer clientChannelHandler;
    private HttpListenerRegistry httpListenerRegistry;
    private WebSocketsHandlersRegistry webSocketsHandlersRegistry = new WebSocketsHandlersRegistry(){};
    private Scheduler selectorsScheduler;
    private int selectorsCount = DEFAULT_SELECTORS_COUNT;
    private Supplier<Long> shutdownTimeout;

    private NettyHttpServer() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpServer start() throws IOException {
        this.status = 1;
        try {
            if (this.acceptorGroup == null) {
                this.acceptorGroup = new NioEventLoopGroup(1, (Executor)this.selectorsScheduler);
            }
            if (this.workerGroup == null) {
                this.workerGroup = new NioEventLoopGroup(this.selectorsCount - 1, (Executor)this.selectorsScheduler);
            }
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            bootstrap.childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.acceptorGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new HttpLoggingHandler())).childHandler((ChannelHandler)this.clientChannelHandler);
            this.serverChannel = bootstrap.bind(this.serverAddress.getAddress(), this.serverAddress.getPort()).sync().channel();
            this.status = 2;
            LOGGER.info("HTTP Server is listening on address: {}", (Object)this.serverAddress);
            return this;
        }
        catch (InterruptedException e) {
            this.status = 0;
            this.stop();
            throw new IOException(e);
        }
    }

    public HttpServer stop() {
        this.status = 3;
        if (this.serverChannel != null) {
            ChannelFuture channelFuture = this.serverChannel.close();
            this.clientChannelHandler.waitForConnectionsToBeClosed(this.shutdownTimeout.get(), TimeUnit.MILLISECONDS);
            channelFuture.syncUninterruptibly();
            this.serverChannel = null;
        }
        if (this.acceptorGroup != null) {
            this.acceptorGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
            this.acceptorGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
            this.workerGroup = null;
        }
        this.status = 0;
        return this;
    }

    public void dispose() {
        if (!this.isStopped()) {
            this.stop();
        }
        if (this.onDisposeCallback != null) {
            this.onDisposeCallback.run();
        }
        if (this.selectorsScheduler != null) {
            this.selectorsScheduler.stop();
            this.selectorsScheduler = null;
        }
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public HttpConstants.Protocol getProtocol() {
        return this.sslContext == null ? HttpConstants.Protocol.HTTP : HttpConstants.Protocol.HTTPS;
    }

    public boolean isStopping() {
        return 3 == this.status;
    }

    public boolean isStopped() {
        return 0 == this.status;
    }

    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.httpListenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder(methods).build()).path(path).build());
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.httpListenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    public WebSocketHandlerManager addWebSocketHandler(WebSocketHandler handler) {
        return this.webSocketsHandlersRegistry.addWebSocketHandler(handler);
    }

    public static class Builder {
        private final NettyHttpServer product = new NettyHttpServer();

        Builder() {
        }

        public HttpServer build() {
            Preconditions.checkArgument((this.product.serverAddress != null ? 1 : 0) != 0, (String)"Server address can't be null");
            Preconditions.checkArgument((this.product.httpListenerRegistry != null ? 1 : 0) != 0, (String)"Listener registry can't be null");
            Preconditions.checkArgument((this.product.shutdownTimeout != null ? 1 : 0) != 0, (String)"Shutdown timeout Supplier can't be null");
            return this.product;
        }

        public Builder withSslContext(SslContext sslContext) {
            this.product.sslContext = sslContext;
            return this;
        }

        public Builder withServerAddress(InetSocketAddress socketAddress) {
            this.product.serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
            return this;
        }

        public Builder withHttpListenerRegistry(HttpListenerRegistry httpListenerRegistry) {
            this.product.httpListenerRegistry = httpListenerRegistry;
            return this;
        }

        public Builder withWebSocketsHandlersRegistry(WebSocketsHandlersRegistry webSocketsHandlersRegistry) {
            this.product.webSocketsHandlersRegistry = webSocketsHandlersRegistry;
            return this;
        }

        public Builder doOnDispose(Runnable onDisposeCallback) {
            this.product.onDisposeCallback = onDisposeCallback;
            return this;
        }

        public Builder withClientChannelHandler(AcceptedConnectionChannelInitializer clientChannelHandler) {
            this.product.clientChannelHandler = clientChannelHandler;
            return this;
        }

        public Builder withSelectorsScheduler(Scheduler selectorsScheduler) {
            this.product.selectorsScheduler = selectorsScheduler;
            return this;
        }

        public Builder withSelectorsCount(int selectorsCount) {
            this.product.selectorsCount = selectorsCount;
            return this;
        }

        public Builder withShutdownTimeout(Supplier<Long> shutdownTimeout) {
            this.product.shutdownTimeout = shutdownTimeout;
            return this;
        }
    }
}

